/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile.base;

import java.util.List;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.tile.base.TileStorage;
import mariculture.core.util.ITank;
import mariculture.core.util.Tank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileStorageTank
extends TileStorage
implements IFluidHandler,
ITank {
    public Tank tank;

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(ForgeDirection.UNKNOWN, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public FluidStack getFluid(int transfer) {
        if (this.tank.getFluid() == null) {
            return null;
        }
        if (this.tank.getFluidAmount() - transfer < 0) {
            return null;
        }
        return new FluidStack(this.tank.getFluidID(), transfer);
    }

    @Override
    public String getFluidName() {
        return FluidHelper.getFluidName(this.tank.getFluid());
    }

    @Override
    public List getFluidQty(List tooltip) {
        return FluidHelper.getFluidQty(tooltip, this.tank.getFluid(), this.tank.getCapacity());
    }

    @Override
    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid(byte tank) {
        return this.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid, byte tank) {
        this.setFluid(fluid);
    }

    @Override
    public int getTankScaled(int i) {
        int qty = this.tank.getFluidAmount();
        int max = this.tank.getCapacity();
        return max != 0 ? qty * i / max : 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
    }
}

