/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import mariculture.core.network.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileCustom
extends TileEntity {
    private float hardness;
    private float resist;
    private Block[] theBlocks = new Block[6];
    private int[] theBlockMetas = new int[6];
    private int[] theSides = new int[6];
    private String name = "CustomTile";

    private int size() {
        return this.theBlocks.length;
    }

    public String name() {
        return this.name;
    }

    public Block theBlocks(int i) {
        return this.theBlocks[i] != null ? this.theBlocks[i] : Blocks.field_150348_b;
    }

    public int theBlockMetas(int i) {
        return this.theBlockMetas.length > i ? this.theBlockMetas[i] : 0;
    }

    public int theBlockSides(int i) {
        return this.theSides.length > i ? this.theSides[i] : 0;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resist;
    }

    public boolean canUpdate() {
        return false;
    }

    public void readData(NBTTagCompound nbt) {
        for (int i = 0; i < 6; ++i) {
            this.theBlocks[i] = (Block)Block.field_149771_c.func_82594_a(nbt.func_74779_i("BlockIdentifier" + i));
        }
        this.resist = nbt.func_74760_g("BlockResistance");
        this.hardness = nbt.func_74760_g("BlockHardness");
        this.theBlockMetas = nbt.func_74759_k("BlockMetas");
        this.theSides = nbt.func_74759_k("BlockSides");
        this.name = nbt.func_74779_i("Name");
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readData(nbt);
    }

    public void writeData(NBTTagCompound nbt) {
        for (int i = 0; i < 6; ++i) {
            nbt.func_74778_a("BlockIdentifier" + i, Block.field_149771_c.func_148750_c((Object)this.theBlocks[i]));
        }
        nbt.func_74776_a("BlockResistance", this.resist);
        nbt.func_74776_a("BlockHardness", this.hardness);
        nbt.func_74783_a("BlockMetas", this.theBlockMetas);
        nbt.func_74783_a("BlockSides", this.theSides);
        nbt.func_74778_a("Name", this.name);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeData(nbt);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void updateHardness() {
        this.hardness = 0.0f;
        for (int i = 0; i < 6; ++i) {
            this.hardness += this.theBlocks[i].func_149712_f(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.hardness /= 6.0f;
    }

    public void updateResistance() {
        this.resist = 0.0f;
        for (int i = 0; i < 6; ++i) {
            this.resist += this.theBlocks[i].getExplosionResistance(null, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.0, 0.0, 0.0);
        }
        this.resist /= 6.0f;
    }

    public void set(Block[] blocks, int[] metas, int[] sides, String name) {
        this.theBlocks = blocks;
        this.theBlockMetas = metas;
        this.theSides = sides;
        this.name = name;
        this.updateHardness();
        this.updateResistance();
        this.updateRender();
    }

    public boolean setSide(int side, Block block, int meta, int sideTexture) {
        boolean ret = false;
        if (this.size() == 6) {
            if (this.theBlocks[side] != block || this.theBlockMetas[side] != meta || this.theSides[side] != sideTexture) {
                ret = true;
            }
            this.theBlocks[side] = block;
            this.theBlockMetas[side] = meta;
            this.theSides[side] = sideTexture;
            this.updateHardness();
            this.updateResistance();
            this.updateRender();
        }
        return ret;
    }

    public void updateRender() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.updateRender(this);
        }
    }
}

