/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import mariculture.core.util.PowerHelper;
import mariculture.factory.tile.TileCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCustomPowered
extends TileCustom
implements IEnergyHandler {
    private int tick;
    private ForgeDirection cameFrom;
    private EnergyStorage storage = new EnergyStorage(6000);
    public static ArrayList<Object[]> handlers = new ArrayList();

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.storage.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.storage.writeToNBT(tagCompound);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        this.cameFrom = from;
        if (this.storage.getEnergyStored() > 0) {
            IEnergyHandler handler = null;
            Object[] res = PowerHelper.getNextEnergyHandler(this.cameFrom, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (res[0] != null) {
                handler = (IEnergyHandler)res[0];
                this.cameFrom = (ForgeDirection)res[1];
            }
            if (handler != null && handler.canConnectEnergy(this.cameFrom)) {
                this.storage.modifyEnergyStored(-handler.receiveEnergy(this.cameFrom.getOpposite(), Math.min(this.storage.getMaxEnergyStored(), this.storage.getEnergyStored()), false));
            }
        }
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    static {
        handlers.add(new Object[]{-1, 0, 0, ForgeDirection.WEST});
        handlers.add(new Object[]{0, 0, 1, ForgeDirection.SOUTH});
        handlers.add(new Object[]{0, 1, 0, ForgeDirection.UP});
        handlers.add(new Object[]{0, 0, -1, ForgeDirection.NORTH});
        handlers.add(new Object[]{1, 0, 0, ForgeDirection.EAST});
        handlers.add(new Object[]{0, -1, 0, ForgeDirection.DOWN});
    }
}

