/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import mariculture.api.util.CachedCoords;
import mariculture.core.helpers.BlockTransferHelper;
import mariculture.core.helpers.cofh.BlockHelper;
import mariculture.core.util.IFaceable;
import mariculture.factory.tile.TileRotor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileGenerator
extends TileEntity
implements IEnergyConnection,
IFaceable {
    private static final int MAX_TRANSFER = 5000;
    public ForgeDirection orientation = ForgeDirection.NORTH;

    public boolean onTick(int i) {
        return this.field_145850_b.func_72820_D() % (long)i == 0L;
    }

    public void reset() {
        if (this.orientation != null) {
            int i = 1;
            while (this.isRotor(this.field_145850_b, this.field_145851_c + this.orientation.getOpposite().offsetX * i, this.field_145848_d, this.field_145849_e + this.orientation.getOpposite().offsetZ * i)) {
                ((TileRotor)this.field_145850_b.func_147438_o(this.field_145851_c + this.orientation.getOpposite().offsetX * i, this.field_145848_d, this.field_145849_e + this.orientation.getOpposite().offsetZ * i)).setMaster(new CachedCoords(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                ++i;
            }
        }
    }

    private boolean isRotor(World world, int x, int y, int z) {
        return world.func_147438_o(x, y, z) instanceof TileRotor;
    }

    private TileRotor getRotorFromCoords(CachedCoords cord) {
        return (TileRotor)this.field_145850_b.func_147438_o(cord.x, cord.y, cord.z);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public boolean canUpdate() {
        return false;
    }

    public void addEnergy(int energy) {
        if (energy >= 0) {
            for (Integer i : BlockTransferHelper.getSides()) {
                TileEntity tile;
                ForgeDirection dir = ForgeDirection.values()[i];
                if (this.orientation == null || dir == this.orientation || dir == this.orientation.getOpposite() || !((tile = BlockHelper.getAdjacentTileEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir)) instanceof IEnergyHandler) || energy <= 0 || !((IEnergyHandler)tile).canConnectEnergy(dir.getOpposite())) continue;
                int extract = -((IEnergyHandler)tile).receiveEnergy(dir.getOpposite(), Math.min(energy, 5000), false);
            }
        }
    }

    @Override
    public boolean rotate() {
        this.setFacing(mariculture.core.helpers.BlockHelper.rotate(this.orientation));
        return true;
    }

    @Override
    public ForgeDirection getFacing() {
        return this.orientation;
    }

    @Override
    public void setFacing(ForgeDirection dir) {
        this.orientation = dir;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.orientation = ForgeDirection.getOrientation((int)nbt.func_74762_e("Orientation"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Orientation", this.orientation.ordinal());
    }
}

