/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import java.util.ArrayList;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.Core;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.lib.PlansMeta;
import mariculture.core.tile.base.TileMachine;
import mariculture.core.util.IHasNotification;
import mariculture.core.util.IProgressable;
import mariculture.factory.blocks.BlockItemCustom;
import mariculture.factory.items.ItemPlan;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileSawmill
extends TileMachine
implements IHasNotification,
IProgressable {
    public static final int TOP = 6;
    public static final int NORTH = 7;
    public static final int SOUTH = 8;
    public static final int WEST = 9;
    public static final int EAST = 10;
    public static final int BOTTOM = 11;
    public static final int OUT = 12;
    public int selected = 3;

    public TileSawmill() {
        this.max = MachineSpeeds.getSawmillSpeed();
        this.inventory = new ItemStack[13];
        this.setting = FeatureEject.EjectSetting.ITEM;
        this.output = new int[]{12};
    }

    public int[] func_94128_d(int side) {
        switch (side) {
            case 0: {
                return new int[]{11, 12};
            }
            case 1: {
                return new int[]{6, 12};
            }
            case 2: {
                return new int[]{7, 12};
            }
            case 3: {
                return new int[]{8, 12};
            }
            case 4: {
                return new int[]{9, 12};
            }
            case 5: {
                return new int[]{10, 12};
            }
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 12) {
            return false;
        }
        if (slot < 6) {
            return stack.func_77973_b() instanceof ItemPlan;
        }
        if (stack.func_77973_b() instanceof BlockItemCustom) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemBlock || stack.func_77973_b() == Items.field_151008_G;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 12;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public boolean canWork() {
        return FeatureRedstone.RedstoneMode.canWork(this, this.mode) && this.hasPlanSelected() && this.allSidesFilled() && this.hasRoom(this.getResult());
    }

    private boolean hasPlanSelected() {
        return this.inventory[this.selected] != null && this.inventory[this.selected].func_77973_b() instanceof ItemPlan;
    }

    private boolean allSidesFilled() {
        return this.inventory[6] != null && this.inventory[11] != null && this.inventory[7] != null && this.inventory[8] != null && this.inventory[10] != null && this.inventory[9] != null;
    }

    private boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        if (stack1.func_77942_o() && stack2.func_77942_o()) {
            return PlansMeta.matches(stack1.field_77990_d, stack2.field_77990_d);
        }
        return stack1.field_77990_d == null && stack2.field_77990_d == null;
    }

    @Override
    public boolean hasRoom(ItemStack stack) {
        if (this.setting.canEject(FeatureEject.EjectSetting.ITEM)) {
            return true;
        }
        if (this.inventory[12] == null) {
            return true;
        }
        return this.areStacksEqual(this.inventory[12], stack) && this.inventory[12].field_77994_a + stack.field_77994_a < this.inventory[12].func_77976_d();
    }

    private boolean isFeather(int slot) {
        return this.inventory[slot].func_77973_b() == Items.field_151008_G;
    }

    private String getBlock(int slot) {
        if (this.isFeather(slot)) {
            return Block.field_149771_c.func_148750_c((Object)Core.air);
        }
        return Block.field_149771_c.func_148750_c((Object)Block.func_149634_a((Item)this.inventory[slot].func_77973_b()));
    }

    private int getMeta(int slot) {
        if (this.isFeather(slot)) {
            return 1;
        }
        return this.inventory[slot].func_77960_j();
    }

    public ItemStack getResult() {
        String[] blocks = new String[]{this.getBlock(11), this.getBlock(6), this.getBlock(7), this.getBlock(8), this.getBlock(9), this.getBlock(10)};
        int[] metas = new int[]{this.getMeta(11), this.getMeta(6), this.getMeta(7), this.getMeta(8), this.getMeta(9), this.getMeta(10)};
        ItemStack stack = PlansMeta.getBlockStack(PlansMeta.getType(this.inventory[this.selected]));
        stack.func_77982_d(new NBTTagCompound());
        for (int i = 0; i < 6; ++i) {
            stack.field_77990_d.func_74778_a("BlockIdentifier" + i, blocks[i]);
        }
        stack.field_77990_d.func_74776_a("BlockResistance", 0.0f);
        stack.field_77990_d.func_74776_a("BlockHardness", 0.0f);
        stack.field_77990_d.func_74783_a("BlockMetas", metas);
        stack.field_77990_d.func_74783_a("BlockSides", new int[]{0, 0, 0, 0, 0, 0});
        stack.field_77990_d.func_74778_a("Name", stack.func_82833_r());
        stack.field_77994_a = ((ItemPlan)this.inventory[this.selected].func_77973_b()).getStackSize(this.inventory[this.selected]);
        if (MaricultureHandlers.upgrades.hasUpgrade("ethereal", this)) {
            stack.field_77994_a *= 2;
        }
        return stack;
    }

    @Override
    public void process() {
        ItemStack result = this.getResult();
        this.helper.insertStack(result, this.output);
        for (int i = 6; i < 12; ++i) {
            --this.inventory[i].field_77994_a;
            if (this.inventory[i].field_77994_a != 0) continue;
            Item var2 = this.inventory[i].func_77973_b().func_77668_q();
            this.inventory[i] = var2 == null ? null : new ItemStack(var2);
        }
        this.inventory[this.selected].func_96631_a(1, this.field_145850_b.field_73012_v);
        if (this.inventory[this.selected].func_77960_j() > this.inventory[this.selected].func_77958_k()) {
            this.inventory[this.selected] = null;
        }
    }

    @Override
    public void setGUIData(int id, int value) {
        super.setGUIData(id, value);
        if (id - this.offset == 0) {
            this.selected = value;
        }
    }

    @Override
    public ArrayList<Integer> getGUIData() {
        ArrayList<Integer> list = super.getGUIData();
        list.add(this.selected);
        return list;
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        switch (type) {
            case NO_PLAN: {
                return !this.hasPlanSelected();
            }
            case MISSING_SIDE: {
                return !this.allSidesFilled();
            }
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.selected = nbt.func_74762_e("PlanSelected");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("PlanSelected", this.selected);
    }
}

