/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import mariculture.Mariculture;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.MaricultureTab;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.RecipeSifter;
import mariculture.api.fishery.RodType;
import mariculture.core.Core;
import mariculture.core.config.FishMechanics;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.items.ItemBattery;
import mariculture.core.lib.ItemLib;
import mariculture.core.lib.Modules;
import mariculture.core.lib.RenderIds;
import mariculture.core.util.Fluids;
import mariculture.fishery.BaitListingsHandler;
import mariculture.fishery.EntityBass;
import mariculture.fishery.EntityHook;
import mariculture.fishery.EntityItemFireImmune;
import mariculture.fishery.Fish;
import mariculture.fishery.FishFoodHandler;
import mariculture.fishery.FishMutationHandler;
import mariculture.fishery.FisheryEventHandler;
import mariculture.fishery.FishingHandler;
import mariculture.fishery.FishingLoot;
import mariculture.fishery.FishyHelper;
import mariculture.fishery.ShapelessFishRecipe;
import mariculture.fishery.SifterHandler;
import mariculture.fishery.blocks.BlockItemNet;
import mariculture.fishery.blocks.BlockNeonLamp;
import mariculture.fishery.blocks.fluids.BlockBlood;
import mariculture.fishery.blocks.fluids.BlockChlorophyll;
import mariculture.fishery.blocks.fluids.BlockCustard;
import mariculture.fishery.blocks.fluids.BlockEnder;
import mariculture.fishery.blocks.fluids.BlockFishOil;
import mariculture.fishery.blocks.fluids.BlockFlux;
import mariculture.fishery.blocks.fluids.BlockGunpowder;
import mariculture.fishery.blocks.fluids.BlockIce;
import mariculture.fishery.blocks.fluids.BlockMana;
import mariculture.fishery.blocks.fluids.BlockPoison;
import mariculture.fishery.items.ItemArmorFishingHat;
import mariculture.fishery.items.ItemBait;
import mariculture.fishery.items.ItemDroplet;
import mariculture.fishery.items.ItemEgg;
import mariculture.fishery.items.ItemFishy;
import mariculture.fishery.items.ItemFluxRod;
import mariculture.fishery.items.ItemRod;
import mariculture.fishery.items.ItemScanner;
import mariculture.fishery.items.ItemTemperatureControl;
import mariculture.fishery.tile.TileAutofisher;
import mariculture.fishery.tile.TileFeeder;
import mariculture.fishery.tile.TileFishTank;
import mariculture.fishery.tile.TileHatchery;
import mariculture.fishery.tile.TileIncubator;
import mariculture.fishery.tile.TileSifter;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.RecipeSorter;

public class Fishery
extends Modules.RegistrationModule {
    public static Block lampsOff;
    public static Block lampsOn;
    public static Item fishEggs;
    public static Item bait;
    public static Item rodWood;
    public static Item rodTitanium;
    public static Item rodReed;
    public static Item rodFlux;
    public static Item fishy;
    public static Item net;
    public static Item scanner;
    public static Item tempControl;
    public static Item droplet;
    public static Item fishinghat;
    private static ItemArmor.ArmorMaterial armorFishing;

    @Override
    public void registerHandlers() {
        if (Fishing.fishing == null) {
            Fishing.fishing = new FishingHandler();
        }
        if (Fishing.fishHelper == null) {
            Fishing.fishHelper = new FishyHelper();
        }
        Fishing.mutation = new FishMutationHandler();
        Fishing.food = new FishFoodHandler();
        Fishing.sifter = new SifterHandler();
        MinecraftForge.EVENT_BUS.register((Object)new FisheryEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BaitListingsHandler());
    }

    @Override
    public void registerItems() {
        bait = new ItemBait().func_77655_b("bait");
        rodReed = new ItemRod(96, 24).func_77655_b("rod.reed");
        rodWood = new ItemRod(320, 10).func_77655_b("rod.wood");
        rodTitanium = new ItemRod(640, 16).func_77655_b("rod.titanium");
        rodFlux = new ItemFluxRod().func_77655_b("rod.flux");
        fishy = new ItemFishy().func_77655_b("fishy").func_77637_a((CreativeTabs)MaricultureTab.tabFishery);
        net = new BlockItemNet().func_77655_b("net");
        scanner = new ItemScanner().func_77655_b("scanner");
        fishEggs = new ItemEgg().func_77655_b("eggs.fish");
        tempControl = new ItemTemperatureControl().func_77655_b("temperature.control");
        droplet = new ItemDroplet().func_77655_b("droplet");
        fishinghat = new ItemArmorFishingHat(armorFishing, RenderIds.FISHING, 0).func_77655_b("fishinghat");
        RegistryHelper.registerItems(new Item[]{bait, rodWood, rodReed, rodTitanium, fishy, net, rodFlux, scanner, fishEggs, tempControl, droplet, fishinghat});
    }

    @Override
    public void registerFluids() {
        FluidHelper.addFluid("fish_food", "fishfood", 512, 16, 12);
        FluidHelper.addFluid("fish_oil", "fishoil", 2000, 1, 100);
        FluidHelper.addFluid("milk", 2000, 24, 100);
        FluidHelper.addFluid("custard", 2000, 25, 100);
        FluidHelper.addFluid("dirt", 100);
        FluidHelper.addFluid("gunpowder", 125);
        FluidHelper.addFluid("flux", 100);
        FluidHelper.addFluid("ender", 25);
        FluidHelper.addFluid("ice", 125);
        FluidHelper.addFluid("blood", 100);
        FluidHelper.addFluid("mana", 100);
        FluidHelper.addFluid("poison", 250);
        FluidHelper.addFluid("chlorophyll", 500);
        FluidHelper.registerBucket(Fluids.getFluid("dirt"), 1000, 3);
        FluidHelper.registerBucket(Fluids.getFluid("custard"), 1000, 2);
        FluidHelper.registerBucket(Fluids.getFluid("fish_oil"), 1000, 1);
        FluidHelper.registerBucket(Fluids.getFluid("gunpowder"), 1000, 4);
        FluidHelper.registerBucket(Fluids.getFluid("flux"), 1000, 5);
        FluidHelper.registerBucket(Fluids.getFluid("ender"), 1000, 6);
        FluidHelper.registerBucket(Fluids.getFluid("ice"), 1000, 7);
        FluidHelper.registerBucket(Fluids.getFluid("blood"), 1000, 8);
        FluidHelper.registerBucket(Fluids.getFluid("mana"), 1000, 9);
        FluidHelper.registerBucket(Fluids.getFluid("poison"), 1000, 10);
        FluidHelper.registerBucket(Fluids.getFluid("chlorophyll"), 1000, 11);
        FluidHelper.registerVanillaBottle(Fluids.getFluid("fish_food"), 256, 28);
        FluidHelper.registerVanillaBottle(Fluids.getFluid("fish_oil"), 1000, 29);
        FluidHelper.registerVanillaBottle(Fluids.getFluid("milk"), 1000, 30);
        FluidHelper.registerVanillaBottle(Fluids.getFluid("custard"), 1000, 31);
        FluidContainerRegistry.registerFluidContainer((FluidStack)Fluids.getFluidStack("custard", 250), (ItemStack)new ItemStack(Core.food, 1, 3), (ItemStack)new ItemStack(Items.field_151054_z));
        FluidContainerRegistry.registerFluidContainer((FluidStack)Fluids.getFluidStack("milk", 1000), (ItemStack)new ItemStack(Items.field_151117_aB), (ItemStack)new ItemStack(Items.field_151133_ar));
    }

    @Override
    public void registerBlocks() {
        FluidHelper.setBlock(BlockFishOil.class, "fish_oil", "fish.oil");
        FluidHelper.setBlock(BlockCustard.class, "custard");
        FluidHelper.setBlock(BlockGunpowder.class, "gunpowder", "gunpowder.molten");
        FluidHelper.setBlock(BlockFlux.class, "flux", "flux.molten");
        FluidHelper.setBlock(BlockEnder.class, "ender", "ender.molten");
        FluidHelper.setBlock(BlockIce.class, "ice", "ice.molten");
        FluidHelper.setBlock(BlockBlood.class, "blood");
        FluidHelper.setBlock(BlockMana.class, "mana");
        FluidHelper.setBlock(BlockPoison.class, "poison");
        FluidHelper.setBlock(BlockChlorophyll.class, "chlorophyll");
        lampsOff = new BlockNeonLamp(true, "lamp_on_").func_149663_c("lamps.off");
        lampsOn = new BlockNeonLamp(false, "lamp_off_").func_149663_c("lamps.on");
        RegistryHelper.registerBlocks(new Block[]{lampsOff, lampsOn});
        RegistryHelper.registerTiles(new Class[]{TileAutofisher.class, TileIncubator.class, TileFeeder.class, TileFishTank.class, TileSifter.class, TileHatchery.class});
    }

    @Override
    public void registerOther() {
        RecipeSorter.register((String)"mariculture:caviar", ShapelessFishRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        this.registerEntities();
        Fish.init();
        this.registerRods();
        if (MaricultureTab.tabFishery != null) {
            MaricultureTab.tabFishery.setIcon(new ItemStack(rodWood), true);
        }
    }

    private void registerEntities() {
        EntityRegistry.registerModEntity(EntityBass.class, (String)"BassBomb", (int)41, (Object)Mariculture.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityHook.class, (String)"FishingHook", (int)45, (Object)Mariculture.instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityItemFireImmune.class, (String)"EntityItemImmune", (int)46, (Object)Mariculture.instance, (int)80, (int)30, (boolean)true);
    }

    private void registerRods() {
        Fishing.fishing.registerRod((Item)Items.field_151112_aM, RodType.DIRE);
        Fishing.fishing.registerRod(rodReed, RodType.OLD);
        Fishing.fishing.registerRod(rodWood, RodType.GOOD);
        Fishing.fishing.registerRod(rodTitanium, RodType.SUPER);
        Fishing.fishing.registerRod(rodFlux, RodType.FLUX);
    }

    @Override
    public void registerRecipes() {
        this.addBait();
        this.addDropletRecipes();
        this.addFishRecipes();
        FishingLoot.add();
        ((ItemRod)rodReed).setRepairMaterial(RecipeHelper._(ItemLib.reeds));
        ((ItemRod)rodWood).setRepairMaterial(ItemLib.polishedStick);
        ((ItemRod)rodTitanium).setRepairMaterial(ItemLib.polishedTitanium);
        RecipeHelper.addFishingRodRecipe(RecipeHelper._(rodReed), ItemLib.reeds);
        RecipeHelper.addFishingRodRecipe(RecipeHelper._(rodWood), ItemLib.polishedStick);
        RecipeHelper.addFishingRodRecipe(RecipeHelper._(rodTitanium), ItemLib.polishedTitanium);
        RecipeHelper.addShaped(ItemBattery.make(RecipeHelper._(rodFlux), 0), new Object[]{"  R", " RS", "B S", Character.valueOf('R'), rodTitanium, Character.valueOf('S'), ItemLib.string, Character.valueOf('B'), ItemLib.titaniumBattery});
        RecipeHelper.addVatItemRecipe(RecipeHelper._(ItemLib.leatherCap), Fluids.getFluidName("fish_oil"), 25000, RecipeHelper._(fishinghat), 25);
        RecipeHelper.addVatItemRecipe("logWood", Fluids.getFluidName("fish_oil"), 30000, ItemLib.polishedLog, 45);
        RecipeHelper.addVatItemRecipe("plankWood", Fluids.getFluidName("fish_oil"), 10000, ItemLib.polishedPlank, 30);
        RecipeHelper.addVatItemRecipe("stickWood", Fluids.getFluidName("fish_oil"), 5000, ItemLib.polishedStick, 15);
        RecipeHelper.addShapeless(RecipeHelper._(ItemLib.polishedPlank, 4), new Object[]{ItemLib.polishedLog});
        RecipeHelper.addShaped(RecipeHelper._(ItemLib.polishedStick, 4), new Object[]{"S", "S", Character.valueOf('S'), ItemLib.polishedPlank});
        RecipeHelper.addVatItemRecipe(ItemLib.titaniumRod, Fluids.getFluidName("fish_oil"), 6500, ItemLib.polishedTitanium, 30);
        RecipeHelper.addShapeless(ItemLib.thermometer, new Object[]{"fish", ItemLib.compass});
        RecipeHelper.addBlockCasting(Fluids.getFluidStack("dirt", 1000), new ItemStack(ItemLib.dirt));
        RecipeHelper.addShaped(RecipeHelper._(ItemLib.fishingNet, 4), new Object[]{"SWS", "WWW", "SWS", Character.valueOf('S'), "stickWood", Character.valueOf('W'), ItemLib.string});
        RecipeHelper.addShaped(RecipeHelper._(ItemLib.sifter, 2), new Object[]{"PNP", "S S", Character.valueOf('S'), "stickWood", Character.valueOf('P'), "plankWood", Character.valueOf('N'), net});
        RecipeHelper.addShaped(ItemLib.autofisher, new Object[]{" F ", "RPR", "WBW", Character.valueOf('W'), "logWood", Character.valueOf('R'), RecipeHelper._(rodWood), Character.valueOf('F'), "fish", Character.valueOf('B'), ItemLib.baseWood, Character.valueOf('P'), "plankWood"});
        RecipeHelper.addShaped(ItemLib.hatchery, new Object[]{"WWW", "WEW", "WWW", Character.valueOf('W'), ItemLib.wicker, Character.valueOf('E'), RecipeHelper._(RecipeHelper._(fishEggs), Short.MAX_VALUE, 1)});
        RecipeHelper.addShaped(ItemLib.fishFeeder, new Object[]{"WFW", "WCW", "WFW", Character.valueOf('F'), "fish", Character.valueOf('W'), ItemLib.wicker, Character.valueOf('C'), ItemLib.chest});
        RecipeHelper.addShaped(ItemLib.incubatorTop, new Object[]{"DFD", "CHC", Character.valueOf('F'), "fish", Character.valueOf('D'), "dyeBrown", Character.valueOf('C'), ItemLib.greyClay, Character.valueOf('H'), ItemLib.heating});
        RecipeHelper.addShaped(ItemLib.incubatorBase, new Object[]{"DBD", "CHC", Character.valueOf('C'), ItemLib.whiteClay, Character.valueOf('B'), ItemLib.copperBattery, Character.valueOf('D'), "dyeLightBlue", Character.valueOf('H'), ItemLib.heating});
        RecipeHelper.addShaped(ItemLib.fishTank, new Object[]{"AGA", "GFG", "AGA", Character.valueOf('A'), "ingotAluminum", Character.valueOf('G'), "blockGlass", Character.valueOf('F'), "fish"});
        RecipeHelper.addShaped(RecipeHelper._(tempControl), new Object[]{" H ", "CTC", " H ", Character.valueOf('H'), ItemLib.heating, Character.valueOf('C'), ItemLib.cooling, Character.valueOf('T'), ItemLib.titaniumSheet});
        RecipeHelper.addVatItemRecipeResultFluid(RecipeHelper._(RecipeHelper._(ItemLib.sugar), 2), Fluids.getFluidStack("milk", 1000), Fluids.getFluidStack("custard", 1000), 15);
        GameRegistry.addRecipe((IRecipe)new ShapelessFishRecipe(new ItemStack(Core.food, 1, 6), new ItemStack(fishEggs)));
        if (FishMechanics.EASY_SCANNER) {
            RecipeHelper.addShaped(RecipeHelper._(scanner), new Object[]{"WPW", "WFW", "WBW", Character.valueOf('P'), ItemLib.pearls, Character.valueOf('W'), ItemLib.dropletAny, Character.valueOf('F'), "fish", Character.valueOf('B'), ItemLib.copperBattery});
        } else {
            RecipeHelper.addShaped(RecipeHelper._(scanner), new Object[]{"WPE", "NFR", "JBO", Character.valueOf('N'), ItemLib.dropletNether, Character.valueOf('P'), ItemLib.pearls, Character.valueOf('W'), ItemLib.dropletWater, Character.valueOf('R'), ItemLib.dropletEarth, Character.valueOf('F'), "fish", Character.valueOf('O'), ItemLib.dropletEnder, Character.valueOf('E'), ItemLib.dropletFrozen, Character.valueOf('B'), ItemLib.copperBattery, Character.valueOf('J'), ItemLib.dropletPoison});
        }
    }

    private void addBait() {
        Fishing.fishing.addBait(new ItemStack(bait, 1, 1), 10);
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 1), new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE), 2, 3, 40));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 1), new ItemStack((Block)Blocks.field_150349_c), 1, 2, 50));
        Fishing.fishing.addBait(new ItemStack(Items.field_151025_P), 30);
        Fishing.fishing.addBait(new ItemStack(bait, 1, 3), 40);
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Blocks.field_150349_c), 1, 2, 35));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), "treeSapling", 2, 3, 35));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), "treeLeaves", 1, 2, 15));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Blocks.field_150329_H, 0, 1), 4, 5, 45));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Blocks.field_150329_H, 0, 2), 2, 3, 40));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Blocks.field_150329_H, 0, 0), 1, 2, 10));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Blocks.field_150327_N, 1, Short.MAX_VALUE), 2, 5, 20));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 3), new ItemStack((Block)Blocks.field_150328_O, 1, Short.MAX_VALUE), 3, 4, 25));
        Fishing.fishing.addBait(new ItemStack(bait, 1, 2), 55);
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 2), new ItemStack(Items.field_151078_bh), 1, 2, 60));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 2), new ItemStack(Items.field_151082_bd), 14, 22, 20));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 2), new ItemStack(Items.field_151076_bf), 6, 14, 30));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 2), new ItemStack(Items.field_151147_al), 10, 18, 25));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 2), ItemLib.zombie, 8, 15, 80));
        Fishing.fishing.addBait(new ItemStack(bait, 1, 4), 70);
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 4), new ItemStack((Block)Blocks.field_150327_N, 1, Short.MAX_VALUE), 2, 3, 25));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 4), new ItemStack((Block)Blocks.field_150328_O, 1, Short.MAX_VALUE), 1, 2, 30));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 4), new ItemStack((Block)Blocks.field_150398_cm, 1, Short.MAX_VALUE), 3, 5, 30));
        Fishing.fishing.addBait(new ItemStack(bait, 1, 0), 75);
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 0), new ItemStack(Items.field_151034_e), 1, 3, 15));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 0), new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE), 2, 3, 10));
        Fishing.sifter.addRecipe(new RecipeSifter(new ItemStack(bait, 1, 0), new ItemStack((Block)Blocks.field_150349_c), 3, 5, 20));
        Fishing.fishing.addBait(new ItemStack(Items.field_151115_aP, 1, Fish.minnow.getID()), 100);
        Fishing.fishing.addBaitForQuality(new ItemStack(bait, 1, 1), Arrays.asList(RodType.DIRE, RodType.OLD, RodType.FLUX));
        Fishing.fishing.addBaitForQuality(new ItemStack(ItemLib.bread), Arrays.asList(RodType.DIRE, RodType.OLD, RodType.FLUX));
        Fishing.fishing.addBaitForQuality(new ItemStack(bait, 1, 3), Arrays.asList(RodType.OLD, RodType.GOOD, RodType.FLUX));
        Fishing.fishing.addBaitForQuality(new ItemStack(bait, 1, 2), Arrays.asList(RodType.GOOD, RodType.FLUX));
        Fishing.fishing.addBaitForQuality(new ItemStack(bait, 1, 0), Arrays.asList(RodType.GOOD, RodType.SUPER, RodType.FLUX));
        Fishing.fishing.addBaitForQuality(new ItemStack(bait, 1, 4), Arrays.asList(RodType.SUPER, RodType.FLUX));
        Fishing.fishing.addBaitForQuality(new ItemStack(Items.field_151115_aP, 1, Fish.minnow.getID()), Arrays.asList(RodType.SUPER, RodType.FLUX));
    }

    private void addDropletRecipes() {
        for (int i = 0; i < 12; ++i) {
            FluidStack stack = ((ItemDroplet)droplet).getFluidStack(i);
            if (stack == null) continue;
            FluidContainerRegistry.registerFluidContainer((FluidStack)stack, (ItemStack)new ItemStack(droplet, 1, i));
        }
        RecipeHelper.addNuggetCasting(Fluids.getFluidStack("ice", 250), RecipeHelper._(ItemLib.snowball));
        RecipeHelper.addBlockCasting(Fluids.getFluidStack("ice", 1000), RecipeHelper._(ItemLib.ice));
        RecipeHelper.addVatItemRecipe(RecipeHelper._(ItemLib.potato), Fluids.getFluidName("poison"), 1000, RecipeHelper._(ItemLib.poisonPotato), 15);
        RecipeHelper.addVatItemRecipe(ItemLib.pearls, Fluids.getFluidName("ender"), 250, RecipeHelper._(ItemLib.enderPearl), 25);
        RecipeHelper.addVatItemRecipe(RecipeHelper._(RecipeHelper._(ItemLib.cobblestone), 0, 8), Fluids.getFluidName("ender"), 250, RecipeHelper._(ItemLib.endstone), 8);
        RecipeHelper.addVatItemRecipe(RecipeHelper._(RecipeHelper._(ItemLib.sand), 0, 2), Fluids.getFluidName("gunpowder"), 250, RecipeHelper._(ItemLib.tnt), 10);
        RecipeHelper.addFluidAlloyResultItem(Fluids.getFluidStack("dirt", 200), new FluidStack(FluidRegistry.WATER, 1000), RecipeHelper._(ItemLib.clay), 15);
        RecipeHelper.addFluidAlloyResultItem(Fluids.getFluidStack("dirt", 600), Fluids.getFluidStack("chlorophyll", 1000), RecipeHelper._(ItemLib.grass), 15);
        RecipeHelper.addFluidAlloy(Fluids.getFluidStack("flux", 100), new FluidStack(FluidRegistry.WATER, 1000), Fluids.getFluidStack("magnesium", 72), 10);
    }

    @Override
    public void postInit() {
        super.postInit();
        Fish.addRecipes();
    }

    private void addFishRecipes() {
        Fishing.food.addFishFood(new ItemStack(bait, 1, 1), 1);
        Fishing.food.addFishFood(new ItemStack(bait, 1, 2), 2);
        Fishing.food.addFishFood(new ItemStack(bait, 1, 3), 2);
        Fishing.food.addFishFood(new ItemStack(Items.field_151025_P), 8);
        Fishing.food.addFishFood(new ItemStack(bait, 1, 0), 3);
        Fishing.food.addFishFood(new ItemStack(bait, 1, 4), 3);
        Fishing.food.addFishFood(new ItemStack(Core.materials, 1, 14), 12);
        RecipeHelper.addShapeless(ItemLib.calamari, new Object[]{RecipeHelper._(ItemLib.fish, Fish.squid.getID(), 1), ItemLib.bowl});
        RecipeHelper.addSmelting(new ItemStack(Core.food, 1, 2), RecipeHelper._(ItemLib.fish, Fish.salmon.getID(), 1), 0.1f);
        RecipeHelper.addShaped(new ItemStack(Core.food, 16, 0), new Object[]{" B ", "BFB", " B ", Character.valueOf('F'), new ItemStack(Items.field_151115_aP, 1, Fish.cod.getID()), Character.valueOf('B'), Items.field_151025_P});
        RecipeHelper.addShapeless(new ItemStack(Core.food, 1, 4), new Object[]{new ItemStack(Core.food, 1, 3), new ItemStack(Core.food, 1, 0), new ItemStack(Core.food, 1, 0), new ItemStack(Core.food, 1, 0)});
        for (int i = 0; i < 12; ++i) {
            RecipeHelper.addShaped(new ItemStack(lampsOn, 8, i), new Object[]{"PGP", "GFG", "PGP", Character.valueOf('P'), new ItemStack(Core.pearls, 1, i), Character.valueOf('G'), "blockGlassColorless", Character.valueOf('F'), new ItemStack(Items.field_151115_aP, 1, Fish.tetra.getID())});
            RecipeHelper.addShaped(new ItemStack(lampsOn, 4, i), new Object[]{"PGP", "GFG", "PGP", Character.valueOf('P'), new ItemStack(Core.pearls, 1, i), Character.valueOf('G'), "blockGlassColorless", Character.valueOf('F'), ItemLib.dropletFlux});
        }
        RecipeHelper.addUpgrade(5, new Object[]{"WEW", "FRF", "DWD", Character.valueOf('W'), ItemLib.blueWool, Character.valueOf('E'), "blockEmerald", Character.valueOf('F'), new ItemStack(Items.field_151115_aP, 1, Fish.dragon.getID()), Character.valueOf('R'), ItemLib.dragonEgg, Character.valueOf('D'), ItemLib.diamond});
        RecipeHelper.addUpgrade(6, new Object[]{"WEW", "FRF", "DWD", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, 6), Character.valueOf('E'), "blockEmerald", Character.valueOf('F'), new ItemStack(Items.field_151115_aP, 1, Fish.dragon.getID()), Character.valueOf('R'), ItemLib.dragonEgg, Character.valueOf('D'), ItemLib.diamond});
        MaricultureHandlers.crucible.addFuel(new ItemStack(Items.field_151115_aP, 1, Fish.nether.getID()), new FuelInfo(2000, 16, 2400));
    }

    static {
        armorFishing = EnumHelper.addArmorMaterial((String)"FISHING", (int)8, (int[])new int[]{0, 0, 0, 0}, (int)0);
    }
}

