/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.network.PacketHandler;
import mariculture.core.network.PacketParticle;
import mariculture.fishery.Fish;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class FisheryEventHandler {
    Random rand = new Random();

    public static void updateStack(World world, EntityItem entity, int lifespan, ItemStack stack, Random rand) {
        float var2 = MathHelper.func_76128_c((double)entity.field_70121_D.field_72338_b);
        float var4 = (rand.nextFloat() * 2.0f - 1.0f) * entity.field_70130_N;
        float var5 = (rand.nextFloat() * 2.0f - 1.0f) * entity.field_70130_N;
        PacketHandler.sendAround(new PacketParticle(PacketParticle.Particle.SPLASH, 8, entity.field_70165_t - 0.5, entity.field_70163_u - 0.5, entity.field_70161_v - 0.5), world.field_73011_w.field_76574_g, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        entity.lifespan = lifespan;
        entity.func_92058_a(stack);
    }

    @SubscribeEvent
    public void onFishDeath(ItemExpireEvent event) {
        Random rand = new Random();
        ItemStack item = event.entityItem.func_92059_d();
        FishSpecies species = Fishing.fishHelper.getSpecies(item);
        if (species != null) {
            if (!species.isLavaFish() && event.entityItem.func_70055_a(Material.field_151586_h)) {
                event.setCanceled(true);
                return;
            }
            ItemStack stack = species.getRawForm(item.field_77994_a);
            if (stack != null) {
                FisheryEventHandler.updateStack(event.entityItem.field_70170_p, event.entityItem, 6000, stack, rand);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onKillSquid(LivingDropsEvent event) {
        if (event.entity instanceof EntitySquid) {
            EntitySquid entity = (EntitySquid)event.entity;
            ItemStack squid = new ItemStack(Items.field_151115_aP, 1, Fish.squid.getID());
            event.drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, squid));
            if (event.lootingLevel > 0) {
                for (int i = 0; i < event.lootingLevel; ++i) {
                    if (this.rand.nextInt(3) != 0) continue;
                    event.drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, squid));
                }
            }
        }
    }
}

