/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.ICaughtAliveModifier;
import mariculture.api.fishery.IFishing;
import mariculture.api.fishery.Loot;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.config.FishMechanics;
import mariculture.core.config.Vanilla;
import mariculture.core.util.RecipeItem;
import mariculture.fishery.EntityHook;
import mariculture.fishery.items.ItemVanillaRod;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraft.world.World;
import net.minecraftforge.common.FishingHooks;

public class FishingHandler
implements IFishing {
    private static final HashMap<Item, RodType> registry = new HashMap();
    private static final HashMap<RodType, ArrayList<ItemStack>> canUse = new HashMap();
    private static final HashMap<List, Integer> baits = new HashMap();
    private static final HashMap<Loot.Rarity, ArrayList<Loot>> fishing_loot = new HashMap();
    public static ArrayList<FishSpecies> catchables;

    @Override
    public RodType getRodType(ItemStack stack) {
        return stack != null ? registry.get(stack.func_77973_b()) : null;
    }

    @Override
    public void registerRod(Item item, RodType type) {
        registry.put(item, type);
    }

    private boolean isVanillaRod(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemVanillaRod;
    }

    @Override
    public ItemStack handleRightClick(ItemStack stack, World world, EntityPlayer player) {
        RodType rodType = this.getRodType(stack);
        if (!world.field_72995_K && !rodType.canFish(world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, player, stack)) {
            return stack;
        }
        int baitQuality = this.getBait(player, stack)[0];
        int baitSlot = this.getBait(player, stack)[1];
        if (player.field_71104_cf != null) {
            rodType.damage(world, player, stack, player.field_71104_cf.func_146034_e(), world.field_73012_v);
            player.func_71038_i();
        } else if (baitSlot != -1 || !Vanilla.VANILLA_FORCE && stack.func_77973_b() instanceof ItemVanillaRod) {
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            if (!Vanilla.VANILLA_POOR && this.isVanillaRod(stack)) {
                baitQuality = 35;
            }
            EntityHook hook = new EntityHook(world, player, rodType.getDamage(), baitQuality);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)hook);
            }
            if (!player.field_71075_bZ.field_75098_d && baitSlot != -1 && baitQuality > 0) {
                player.field_71071_by.func_70298_a(baitSlot, 1);
            }
            player.func_71038_i();
        }
        return stack;
    }

    private int[] getBait(EntityPlayer player, ItemStack rod) {
        int rightSlot;
        int leftSlot;
        int baitQuality = 0;
        int currentSlot = player.field_71071_by.field_70461_c;
        int foundSlot = -1;
        if (currentSlot > 0 && player.field_71071_by.func_70301_a(leftSlot = currentSlot - 1) != null && this.canUseBait(rod, player.field_71071_by.func_70301_a(leftSlot))) {
            baitQuality = this.getBaitQuality(player.field_71071_by.func_70301_a(leftSlot));
            foundSlot = leftSlot;
        }
        if (foundSlot == -1 && currentSlot < 8 && player.field_71071_by.func_70301_a(rightSlot = currentSlot + 1) != null && this.canUseBait(rod, player.field_71071_by.func_70301_a(rightSlot))) {
            baitQuality = this.getBaitQuality(player.field_71071_by.func_70301_a(rightSlot));
            foundSlot = rightSlot;
        }
        return new int[]{baitQuality, foundSlot};
    }

    @Override
    public void addBait(ItemStack bait, Integer catchRate) {
        baits.put(Arrays.asList(bait.func_77973_b(), bait.func_77960_j()), catchRate);
    }

    @Override
    public void addBaitForQuality(ItemStack bait, List<RodType> rods) {
        for (RodType type : rods) {
            this.addBaitForQuality(bait, type);
        }
    }

    @Override
    public void addBaitForQuality(ItemStack bait, RodType quality) {
        ArrayList<Object> baitList = canUse.get(quality);
        if (baitList == null) {
            baitList = new ArrayList();
        }
        baitList.add(bait);
        canUse.put(quality, baitList);
    }

    @Override
    public int getBaitQuality(ItemStack bait) {
        Integer i = baits.get(Arrays.asList(bait.func_77973_b(), bait.func_77960_j()));
        if (i == null) {
            i = baits.get(Arrays.asList(bait.func_77973_b(), Short.MAX_VALUE));
        }
        return i == null ? 0 : i;
    }

    @Override
    public boolean canUseBait(ItemStack rod, ItemStack bait) {
        RodType quality = this.getRodType(rod);
        if (canUse.containsKey(quality)) {
            ArrayList<ItemStack> baitList = canUse.get(quality);
            if (baitList != null && baitList.size() > 0) {
                for (ItemStack l : baitList) {
                    if (!RecipeItem.equals(bait, l)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public ArrayList<ItemStack> getCanUseList(RodType quality) {
        return canUse.get(quality);
    }

    @Override
    public void addLoot(Loot loot) {
        ArrayList<Loot> lootList = fishing_loot.get((Object)loot.rarity);
        if (lootList == null) {
            lootList = new ArrayList();
        }
        lootList.add(loot);
        fishing_loot.put(loot.rarity, lootList);
        if (loot.quality == null) {
            this.addVanillaLoot(loot.rarity, new WeightedRandomFishable(loot.loot, (int)Math.max(loot.chance / 10.0, 1.0)));
        }
    }

    private void addVanillaLoot(Loot.Rarity rarity, WeightedRandomFishable loot) {
        if (rarity == Loot.Rarity.GOOD || rarity == Loot.Rarity.RARE) {
            FishingHooks.addTreasure((WeightedRandomFishable)loot);
        } else {
            FishingHooks.addJunk((WeightedRandomFishable)loot);
        }
    }

    private boolean isDimensionValid(World world, int id) {
        if (id == Short.MAX_VALUE) {
            return true;
        }
        if (id == 0) {
            return !world.field_73011_w.field_76575_d && world.field_73011_w.field_76574_g != 1;
        }
        return id == world.field_73011_w.field_76574_g;
    }

    private boolean isFishingRodValid(RodType rod, RodType quality, boolean exact) {
        if (quality == null) {
            return true;
        }
        if (exact) {
            return rod == quality;
        }
        return rod.getQuality() >= quality.getQuality();
    }

    private ItemStack getLoot(World world, RodType rod, Loot.Rarity rarity) {
        ArrayList<Loot> loots = fishing_loot.get((Object)rarity);
        Collections.shuffle(loots);
        for (Loot loot : loots) {
            if (loot.loot.func_77973_b() == null || !this.isDimensionValid(world, loot.dimension) || !this.isFishingRodValid(rod, loot.quality, loot.exact)) continue;
            double chance = loot.chance * 10.0;
            if (!((double)world.field_73012_v.nextInt(1000) < chance)) continue;
            return loot.loot.func_77946_l();
        }
        return rarity == Loot.Rarity.JUNK ? FishingHooks.getRandomFishable((Random)world.field_73012_v, (float)0.05f) : FishingHooks.getRandomFishable((Random)world.field_73012_v, (float)0.1f);
    }

    private ItemStack getVanillaLoot(World world, EntityPlayer player, ItemStack stack) {
        float f = world.field_73012_v.nextFloat();
        int i = EnchantmentHelper.func_77506_a((int)Enchantment.field_151370_z.field_77352_x, (ItemStack)stack);
        int j = EnchantmentHelper.func_77506_a((int)Enchantment.field_151369_A.field_77352_x, (ItemStack)stack);
        player.func_71064_a(FishingHooks.getFishableCategory((float)f, (int)i, (int)j).stat, 1);
        return FishingHooks.getRandomFishable((Random)world.field_73012_v, (float)f, (int)i, (int)j);
    }

    @Override
    public ItemStack getCatch(World world, int x, int y, int z, EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return this.getFishForLocation(player, world, x, y, z, RodType.NET);
        }
        RodType type = this.getRodType(stack);
        if (Vanilla.VANILLA_LOOT && type == RodType.DIRE) {
            return this.getVanillaLoot(world, player, stack);
        }
        if (type != null) {
            int chance;
            ItemStack loot = null;
            int lootBonus = EnchantmentHelper.func_77506_a((int)Enchantment.field_151370_z.field_77352_x, (ItemStack)stack);
            if (lootBonus > 0 && world.field_73012_v.nextInt(200) < lootBonus * 10 || (double)world.field_73012_v.nextInt(1000) < Math.max(0.01, type.getChances().get(0))) {
                loot = this.getLoot(world, type, Loot.Rarity.RARE);
            } else {
                double chance2 = Math.max(0.01, type.getChances().get(1));
                if (lootBonus > 0 && world.field_73012_v.nextInt(250) < lootBonus * 10 || (double)world.field_73012_v.nextInt(1000) < Math.max(0.01, type.getChances().get(1))) {
                    loot = this.getLoot(world, type, Loot.Rarity.GOOD);
                } else if (lootBonus > 0 && world.field_73012_v.nextInt(300) < lootBonus * 10 || (double)world.field_73012_v.nextInt(1000) < Math.max(0.01, type.getChances().get(2))) {
                    loot = this.getLoot(world, type, Loot.Rarity.JUNK);
                }
            }
            if (loot == null) {
                return this.getFishForLocation(player, world, x, y, z, type);
            }
            if (loot.func_77956_u() && world.field_73012_v.nextInt(100) < type.getQuality() && (chance = type.getLootEnchantmentChance()) > 0) {
                EnchantmentHelper.func_77504_a((Random)world.field_73012_v, (ItemStack)loot, (int)world.field_73012_v.nextInt(chance));
            }
            return loot;
        }
        return new ItemStack(Items.field_151055_y);
    }

    private ItemStack getFishForLocation(EntityPlayer player, World world, int x, int y, int z, RodType type) {
        double modifier = 10.0;
        if (player != null) {
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ICaughtAliveModifier)) continue;
                modifier += ((ICaughtAliveModifier)stack.func_77973_b()).getModifier();
            }
        }
        if (catchables == null) {
            catchables = new ArrayList();
            for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
                catchables.add(species.getValue());
            }
        }
        Environment.Salinity salt = MaricultureHandlers.environment.getSalinity(world, x, z);
        int temperature = MaricultureHandlers.environment.getTemperature(world, x, y, z);
        for (int i = 0; i < 20; ++i) {
            Collections.shuffle(catchables);
            for (FishSpecies fish : catchables) {
                double catchChance = fish.getCatchChance(world, x, y, z, salt, temperature);
                if (!(catchChance > 0.0) || type.getQuality() < fish.getRodNeeded().getQuality() || !((double)world.field_73012_v.nextInt(1000) < catchChance)) continue;
                if (FishMechanics.IGNORE_BIOMES) {
                    this.catchFish(world.field_73012_v, fish, type, fish.getCaughtAliveChance(world, y) * (modifier * 1.5));
                    continue;
                }
                return this.catchFish(world.field_73012_v, fish, type, fish.getCaughtAliveChance(world, x, y, z, salt, temperature) * modifier);
            }
        }
        return new ItemStack(Items.field_151055_y);
    }

    private ItemStack catchFish(Random rand, FishSpecies fish, RodType quality, double chance) {
        boolean catchAlive;
        boolean alive = false;
        if ((double)rand.nextInt(1000) < chance * FishMechanics.ALIVE_MODIFIER) {
            alive = true;
        }
        if (!(catchAlive = quality.caughtAlive(fish.getSpecies())) && !alive) {
            return fish.getRawForm(1);
        }
        return Fishing.fishHelper.makePureFish(fish);
    }
}

