/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import java.util.Random;
import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.ItemLib;
import mariculture.fishery.EntityBass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FishBass
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{10, 15};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH, Environment.Salinity.BRACKISH, Environment.Salinity.SALINE};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 16;
    }

    @Override
    public int getFertility() {
        return 2000;
    }

    @Override
    public int getWaterRequired() {
        return 45;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletWater, 4.0);
        this.addProduct(ItemLib.dropletDestroy, 5.0);
        this.addProduct(ItemLib.dropletPlant, 3.0);
        this.addProduct(ItemLib.gunpowder, 7.5);
    }

    @Override
    public double getFishOilVolume() {
        return 4.325;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(ItemLib.gunpowder);
    }

    @Override
    public int getFishMealSize() {
        return 5;
    }

    @Override
    public int getFoodStat() {
        return 1;
    }

    @Override
    public float getFoodSaturation() {
        return 0.1f;
    }

    @Override
    public int getFoodDuration() {
        return 1;
    }

    @Override
    public boolean canAlwaysEat() {
        return true;
    }

    @Override
    public ItemStack onRightClick(World world, EntityPlayer player, ItemStack stack, Random rand) {
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (rand.nextFloat() * 0.4f + 0.8f));
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityBass(world, player));
        }
        return stack;
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.GOOD;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return Environment.Height.isOverground(height) ? 15.0 : 5.0;
    }
}

