/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.ItemLib;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FishLamprey
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-3, 5};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 17;
    }

    @Override
    public int getFertility() {
        return 3000;
    }

    @Override
    public int getFoodConsumption() {
        return 2;
    }

    @Override
    public int getWaterRequired() {
        return 350;
    }

    @Override
    public int getAreaOfEffectBonus(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN ? 5 : 0;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletAqua, 7.5);
        this.addProduct(ItemLib.dropletPoison, 6.5);
        this.addProduct(ItemLib.dropletDestroy, 4.5);
        this.addProduct(ItemLib.dropletEarth, 2.0);
    }

    @Override
    public double getFishOilVolume() {
        return 2.25;
    }

    @Override
    public void affectLiving(EntityLivingBase entity) {
        if (entity.field_70170_p.field_73012_v.nextInt(100) == 0) {
            entity.func_70097_a(DamageSource.field_82727_n, 1.0f);
        }
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.SUPER;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return Environment.Height.isDeep(height) ? 15.0 : 0.0;
    }
}

