/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.ItemLib;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class FishNether
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{45, 100};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isLavaFish() {
        return true;
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 6;
    }

    @Override
    public int getFertility() {
        return 666;
    }

    @Override
    public int getWaterRequired() {
        return 55;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletNether, 5.0);
        this.addProduct(ItemLib.netherWart, 1.0);
    }

    @Override
    public double getFishOilVolume() {
        return 0.666;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 120, 0));
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.OLD;
    }

    @Override
    public boolean isWorldCorrect(World world) {
        return world.field_73011_w.field_76575_d;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return 45.0;
    }

    @Override
    public double getCaughtAliveChance(World world, int height) {
        return Environment.Height.isShallows(height) ? 65.0 : 25.0;
    }
}

