/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.ItemLib;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class FishNight
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-10, 66};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 10;
    }

    @Override
    public int getFertility() {
        return 256;
    }

    @Override
    public int getWaterRequired() {
        return 50;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletEnder, 5.0);
    }

    @Override
    public double getFishOilVolume() {
        return 0.333;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        if (!world.func_72935_r()) {
            player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 1800, 0));
        }
    }

    @Override
    public boolean canWorkAtThisTime(boolean isDay) {
        return !isDay;
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.OLD;
    }

    @Override
    public boolean isWorldCorrect(World world) {
        return !world.field_73011_w.field_76575_d;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return world.field_73011_w.field_76574_g == 1 ? 55.0 : (Environment.Height.isCave(height) ? 5.0 : (!world.func_72935_r() ? 35.0 : 0.0));
    }

    @Override
    public double getCaughtAliveChance(World world, int height) {
        return world.field_73011_w.field_76574_g == 1 ? 65.0 : (!world.func_72935_r() ? 44.0 : 0.0);
    }
}

