/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mariculture.api.core.MaricultureTab;
import mariculture.api.util.Text;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.items.ItemMariculture;
import mariculture.core.util.Fluids;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemDroplet
extends ItemMariculture {
    public ItemDroplet() {
        this.func_77637_a(MaricultureTab.tabFishery);
    }

    @Override
    public int getMetaCount() {
        return 12;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        int amount = fluid == null ? 0 : fluid.amount;
        list.add(Text.translate("contains") + " " + amount + Text.translate("mb") + " " + Text.translate("of") + " " + FluidHelper.getFluidName(fluid));
    }

    @Override
    public String getName(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 7: {
                return "aqua";
            }
            case 6: {
                return "attack";
            }
            case 10: {
                return "electric";
            }
            case 5: {
                return "ender";
            }
            case 4: {
                return "nether";
            }
            case 11: {
                return "health";
            }
            case 9: {
                return "magic";
            }
            case 8: {
                return "poison";
            }
            case 3: {
                return "water";
            }
            case 0: {
                return "earth";
            }
            case 2: {
                return "frozen";
            }
            case 1: {
                return "plant";
            }
        }
        return "water";
    }

    public String func_150896_i(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 8: {
                return PotionHelper.field_77920_d;
            }
            case 11: {
                return "+0-1-2-3&4-4+13";
            }
            case 4: {
                return PotionHelper.field_77931_h;
            }
            case 6: {
                return PotionHelper.field_77930_k;
            }
        }
        return super.func_150896_i(stack);
    }

    public FluidStack getFluidStack(int dmg) {
        switch (dmg) {
            case 7: {
                return Fluids.getBalancedStack("hp_water");
            }
            case 6: {
                return Fluids.getBalancedStack("gunpowder");
            }
            case 10: {
                return Fluids.getBalancedStack("flux");
            }
            case 5: {
                return Fluids.getBalancedStack("ender");
            }
            case 4: {
                return new FluidStack(FluidRegistry.LAVA, 100);
            }
            case 11: {
                return Fluids.getBalancedStack("blood");
            }
            case 9: {
                return Fluids.getBalancedStack("mana");
            }
            case 8: {
                return Fluids.getBalancedStack("poison");
            }
            case 3: {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            case 0: {
                return Fluids.getBalancedStack("dirt");
            }
            case 2: {
                return Fluids.getBalancedStack("ice");
            }
            case 1: {
                return Fluids.getBalancedStack("chlorophyll");
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.getMetaCount()];
        for (int i = 0; i < this.icons.length; ++i) {
            if (!this.isActive(i)) continue;
            String name = this.getName(new ItemStack((Item)this, 1, i));
            this.icons[i] = iconRegister.func_94245_a("mariculture:droplet" + name.substring(0, 1).toUpperCase() + name.substring(1));
        }
    }
}

