/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import mariculture.api.core.MaricultureTab;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishDNABase;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.api.util.Text;
import mariculture.fishery.Fish;
import mariculture.fishery.FishyHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemFishy
extends Item {
    private static IIcon egg;

    public ItemFishy() {
        this.func_77637_a(MaricultureTab.tabFishery);
        this.func_77627_a(true);
    }

    public boolean func_77623_v() {
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        FishSpecies species = Fishing.fishHelper.getSpecies(stack);
        if (species != null) {
            return this.func_77658_a() + "." + species.getID();
        }
        return "fishy";
    }

    public String func_77653_i(ItemStack stack) {
        FishSpecies active = FishSpecies.species.get(Fish.species.getDNA(stack));
        FishSpecies inactive = FishSpecies.species.get(Fish.species.getLowerDNA(stack));
        if (active == null || inactive == null) {
            return Text.translate("anyFish");
        }
        if (active != inactive) {
            return "\u00a7b" + active.getName() + "-" + inactive.getName() + " " + Text.localize("fish.data.hybrid") + this.convertToSymbol(Fish.gender.getDNA(stack));
        }
        return "\u00a7b" + active.getName() + this.convertToSymbol(Fish.gender.getDNA(stack));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        FishSpecies species = Fishing.fishHelper.getSpecies(stack);
        if (species != null) {
            for (int i = 0; i < FishDNABase.DNAParts.size(); ++i) {
                FishDNABase.DNAParts.get(i).getInformationDisplay(stack, list);
            }
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        FishSpecies species = Fishing.fishHelper.getSpecies(stack);
        if (species != null) {
            return species.getIcon(Fish.gender.getDNA(stack));
        }
        return new ItemStack(Items.field_151115_aP, 1, 32000).func_77954_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
            species.getValue().registerIcon(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creative, List list) {
        for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
            FishSpecies fishy = species.getValue();
            ItemStack fish = Fishing.fishHelper.makePureFish(fishy);
            list.add(Fish.gender.addDNA(fish, FishyHelper.MALE));
            list.add(Fish.gender.addDNA(fish.func_77946_l(), FishyHelper.FEMALE));
        }
    }

    private String convertToSymbol(int gender) {
        if (gender == FishyHelper.MALE) {
            return "\u2642";
        }
        if (gender == FishyHelper.FEMALE) {
            return "\u2640";
        }
        return "";
    }

    public boolean func_77651_p() {
        return true;
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return 15;
    }
}

