/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.items;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mariculture.api.util.Text;
import mariculture.core.items.ItemBattery;
import mariculture.fishery.items.ItemRod;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemFluxRod
extends ItemRod
implements IEnergyContainerItem {
    private int capacity = 250000;
    private int maxReceive = 250;
    private int maxExtract = 100;

    public ItemFluxRod() {
        super(0, 0);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return 1 + this.capacity;
        }
        return 1 + this.capacity - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return 1 + this.capacity;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (stack.field_77990_d == null) {
            return;
        }
        list.add(Text.translate("charge") + ": " + stack.field_77990_d.func_74762_e("Energy") + " / " + this.capacity + " " + Text.translate("rf"));
        list.add(Text.translate("transfer") + ": " + this.maxReceive + " " + Text.translate("rft"));
        list.add(Text.translate("peruse") + ": " + this.maxExtract + " " + Text.translate("rf"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creative, List list) {
        ItemStack battery = new ItemStack(item, 1, 0);
        list.add(ItemBattery.make(battery, 0));
        list.add(ItemBattery.make(battery, this.capacity));
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        if (container.field_77990_d.func_74762_e("Energy") <= 0) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, this.maxExtract);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }
}

