/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.items;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import mariculture.api.core.MaricultureTab;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.api.util.Text;
import mariculture.core.config.Vanilla;
import mariculture.core.lib.Extra;
import mariculture.core.lib.Modules;
import mariculture.fishery.FishyHelper;
import mariculture.plugins.PluginHungerOverhaul;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemVanillaFish
extends ItemFishFood {
    public static final int LAST_VANILLA = ItemFishFood.FishType.PUFFERFISH.ordinal() + 1;

    public ItemVanillaFish(boolean bool) {
        super(false);
        this.func_77637_a(MaricultureTab.tabFishery);
    }

    public String func_77653_i(ItemStack stack) {
        if (Fishing.fishHelper == null) {
            return super.func_77653_i(stack);
        }
        if (Vanilla.VANILLA_TEXTURES && stack.func_77960_j() < LAST_VANILLA) {
            return super.func_77653_i(stack);
        }
        FishSpecies species = Fishing.fishHelper.getSpecies(stack.func_77960_j());
        if (species == null) {
            return Text.translate("anyFish");
        }
        return StatCollector.func_74838_a((String)"fish.data.dead") + " " + Fishing.fishHelper.getSpecies(stack.func_77960_j()).getName();
    }

    public boolean func_77623_v() {
        return true;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (Vanilla.VANILLA_TEXTURES && stack.func_77960_j() < LAST_VANILLA) {
            return super.getIcon(stack, pass);
        }
        FishSpecies fish = Fishing.fishHelper.getSpecies(stack.func_77960_j());
        return fish != null ? fish.getIcon(1) : super.getIcon(stack, pass);
    }

    public int func_77626_a(ItemStack stack) {
        if (Vanilla.VANILLA_STATS && stack.func_77960_j() < LAST_VANILLA) {
            return super.func_77626_a(stack);
        }
        FishSpecies fish = Fishing.fishHelper.getSpecies(stack.func_77960_j());
        return fish != null ? fish.getFoodDuration() : 32;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (Vanilla.VANILLA_STATS && stack.func_77960_j() < LAST_VANILLA) {
            return super.func_77659_a(stack, world, player);
        }
        FishSpecies fish = Fishing.fishHelper.getSpecies(stack.func_77960_j());
        if (fish != null) {
            if (player.func_71043_e(fish.canAlwaysEat()) && fish.getFoodStat() >= 0) {
                player.func_71008_a(stack, this.func_77626_a(stack));
            }
            return fish.onRightClick(world, player, stack, field_77697_d);
        }
        return super.func_77659_a(stack, world, player);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        if (Vanilla.VANILLA_STATS && stack.func_77960_j() < LAST_VANILLA) {
            return super.func_77654_b(stack, world, player);
        }
        FishSpecies fish = Fishing.fishHelper.getSpecies(stack.func_77960_j());
        if (fish != null) {
            --stack.field_77994_a;
            int food = fish.getFoodStat();
            float sat = fish.getFoodSaturation();
            if (Extra.NERF_FOOD) {
                food = Math.max(1, food / 2);
                sat = Math.max(0.0f, sat / 10.0f);
            }
            player.func_71024_bL().func_75122_a(food, sat);
            world.func_72956_a((Entity)player, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            fish.onConsumed(world, player);
            return stack;
        }
        return super.func_77654_b(stack, world, player);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        FishSpecies fish;
        if (Extra.NERF_FOOD && (fish = Fishing.fishHelper.getSpecies(stack.func_77960_j())) != null) {
            int level = fish.getFoodStat();
            float sat = fish.getFoodSaturation();
            level = Math.max(1, level / 2);
            sat = Math.max(0.0f, sat / 10.0f);
            PluginHungerOverhaul.addInformation(level, sat, list);
        }
    }

    public String func_150896_i(ItemStack stack) {
        FishSpecies fish;
        if (Vanilla.VANILLA_STATS && stack.func_77960_j() < LAST_VANILLA) {
            return super.func_150896_i(stack);
        }
        if (Fishing.fishHelper == null) {
            Fishing.fishHelper = new FishyHelper();
        }
        if ((fish = Fishing.fishHelper.getSpecies(stack.func_77960_j())) != null) {
            return fish.getPotionEffect(stack);
        }
        return super.func_150896_i(stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_71075_bZ.field_75098_d) {
            FishSpecies species = Fishing.fishHelper.getSpecies(stack.func_77960_j());
            if (species != null && species.destroyOnAttack()) {
                --stack.field_77994_a;
            }
            if (stack.field_77994_a == 0) {
                player.func_70062_b(0, null);
            }
        }
        return false;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        FishSpecies species = Fishing.fishHelper.getSpecies(stack.func_77960_j());
        if (species != null) {
            return species.getModifiers(field_111210_e, super.getAttributeModifiers(stack));
        }
        return super.getAttributeModifiers(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creative, List list) {
        if (Modules.isActive(Modules.fishery)) {
            for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
                FishSpecies fishy = species.getValue();
                if (!(fishy.getRawForm(1).func_77973_b() instanceof ItemVanillaFish)) continue;
                list.add(fishy.getRawForm(1));
            }
        } else {
            super.func_150895_a(item, creative, list);
        }
    }
}

