/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.tile;

import cofh.api.energy.IEnergyConnection;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.api.util.CachedCoords;
import mariculture.api.util.Text;
import mariculture.core.config.Machines;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.network.PacketHandler;
import mariculture.core.network.PacketSyncFeeder;
import mariculture.core.tile.base.TileMachineTank;
import mariculture.core.util.Fluids;
import mariculture.core.util.IHasNotification;
import mariculture.fishery.Fish;
import mariculture.fishery.FishFoodHandler;
import mariculture.fishery.FishyHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileFeeder
extends TileMachineTank
implements IHasNotification,
IEnergyConnection {
    private static final int fluid = 3;
    public static final int male = 5;
    public static final int female = 6;
    public ArrayList<CachedCoords> coords = new ArrayList();
    private int isInit = 50;
    private boolean isDay;
    private boolean swap = false;
    private int foodTick;
    private int tankSize;
    public int mPos = 0;
    public int fPos = 0;
    public int mTicker = 0;
    public int fTicker = 0;
    public double mRot = 0.0;
    public double fRot = 0.0;

    public TileFeeder() {
        this.max = MachineSpeeds.getFeederSpeed();
        this.inventory = new ItemStack[13];
        this.output = new int[]{7, 8, 9, 10, 11, 12};
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(5.0, 5.0, 5.0);
    }

    @Override
    public int getTankCapacity(int storage) {
        return 2 * this.tankSize * (storage + 1);
    }

    public int[] func_94128_d(int var1) {
        return new int[]{5, 6, 3, 7, 8, 9, 10, 11, 12};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 5) {
            return this.inventory[5] == null && Fishing.fishHelper.isMale(stack);
        }
        if (slot == 6) {
            return this.inventory[6] == null && Fishing.fishHelper.isFemale(stack);
        }
        if (slot == 3) {
            return FluidHelper.isFluidOrEmpty(stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot > 6;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (!this.field_145850_b.field_72995_K) {
            if (slot == 5 && Fishing.fishHelper.isMale(stack)) {
                this.updateTankSize();
            } else if (slot == 6) {
                PacketHandler.syncInventory(this, this.inventory);
            }
        }
    }

    private void updateTankSize() {
        int xP = 0;
        int xN = 0;
        int yP = 0;
        int yN = 0;
        int zP = 0;
        int zN = 0;
        ItemStack male = this.inventory[5];
        if (male != null) {
            xP = Fish.east.getDNA(male);
            xN = Fish.west.getDNA(male);
            yP = Fish.up.getDNA(male);
            yN = Fish.down.getDNA(male);
            zP = Fish.south.getDNA(male);
            zN = Fish.north.getDNA(male);
        }
        this.coords = new ArrayList();
        for (int x = -5 - xN; x <= 5 + xP; ++x) {
            for (int z = -5 - zN; z <= 5 + zP; ++z) {
                for (int y = -5 - yN; y <= 5 + yP; ++y) {
                    if (!BlockHelper.isFishLiveable(this.field_145850_b, this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z)) continue;
                    this.coords.add(new CachedCoords(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z));
                }
            }
        }
        this.tankSize = this.coords.size();
        this.updateUpgrades();
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.syncInventory(this, this.inventory);
            PacketHandler.sendAround(new PacketSyncFeeder(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.coords), this);
        }
    }

    @Override
    public void process() {
        if (this.swap) {
            this.makeProduct(this.inventory[6]);
        } else {
            this.makeProduct(this.inventory[5]);
        }
        this.damageFish(this.inventory[6], true);
        this.damageFish(this.inventory[5], true);
    }

    private void damageFish(ItemStack fish, boolean giveProduct) {
        FishSpecies species = Fishing.fishHelper.getSpecies(fish);
        if (species != null) {
            int gender = Fish.gender.getDNA(fish);
            if (gender == FishyHelper.FEMALE && MaricultureHandlers.upgrades.hasUpgrade("female", this)) {
                return;
            }
            if (gender == FishyHelper.MALE && MaricultureHandlers.upgrades.hasUpgrade("male", this)) {
                return;
            }
            int reduce = this.max - this.purity * 15;
            fish.field_77990_d.func_74768_a("CurrentLife", fish.field_77990_d.func_74762_e("CurrentLife") - reduce);
            if (fish.field_77990_d.func_74762_e("CurrentLife") <= 0 || MaricultureHandlers.upgrades.hasUpgrade("debugKill", this)) {
                this.killFish(species, gender, giveProduct);
            }
        }
    }

    private void makeProduct(ItemStack fish) {
        FishSpecies species = Fishing.fishHelper.getSpecies(fish);
        if (species != null) {
            for (int i = 0; i < Fish.production.getDNA(fish); ++i) {
                int fertility;
                ItemStack product = species.getProduct(this.field_145850_b.field_73012_v);
                if (product != null) {
                    this.helper.insertStack(product, this.output);
                }
                int gender = Fish.gender.getDNA(fish);
                if (MaricultureHandlers.upgrades.hasUpgrade("female", this) && this.field_145850_b.field_73012_v.nextInt(fertility = Math.max(1, (5500 - Fish.fertility.getDNA(fish)) / 50)) == 0) {
                    this.generateEgg();
                }
                if (!MaricultureHandlers.upgrades.hasUpgrade("male", this) || (product = species.getProduct(this.field_145850_b.field_73012_v)) == null) continue;
                this.helper.insertStack(product, this.output);
            }
        }
    }

    private void killFish(FishSpecies species, int gender, boolean giveProduct) {
        if (giveProduct) {
            ItemStack raw = species.getRawForm(1);
            if (raw != null) {
                this.helper.insertStack(raw, this.output);
            }
            if (gender == FishyHelper.FEMALE) {
                this.generateEgg();
            }
        }
        if (gender == FishyHelper.FEMALE) {
            this.func_70298_a(6, 1);
        } else if (gender == FishyHelper.MALE) {
            this.func_70298_a(5, 1);
        }
    }

    private void generateEgg() {
        if (Fishing.fishHelper.getSpecies(this.inventory[5]) != null) {
            this.helper.insertStack(Fishing.fishHelper.generateEgg(this.inventory[5], this.inventory[6]), this.output);
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isInit <= 0 && this.isInit > -1000) {
                this.isInit = -1000;
                this.updateTankSize();
            } else {
                --this.isInit;
            }
        }
        super.func_145845_h();
    }

    @Override
    public void update() {
        super.update();
        if (this.canWork) {
            ++this.foodTick;
            if (this.onTick(Machines.Ticks.EFFECT_TICK)) {
                if (this.swap) {
                    this.doEffect(this.inventory[5]);
                    this.swap = false;
                } else {
                    this.doEffect(this.inventory[6]);
                    this.swap = true;
                }
            }
            if (this.foodTick % (Machines.Ticks.FISH_FOOD_TICK * 20) == 0) {
                if (this.swap) {
                    this.useFood(this.inventory[5]);
                } else {
                    this.useFood(this.inventory[6]);
                }
            }
            if (Machines.Ticks.PICKUP_TICK >= 0 && this.onTick(Machines.Ticks.PICKUP_TICK)) {
                this.pickupFood();
            }
        }
    }

    private void doEffect(ItemStack fish) {
        FishSpecies species = Fishing.fishHelper.getSpecies(fish);
        if (species != null && !this.field_145850_b.field_72995_K) {
            species.affectWorld(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.coords);
            for (CachedCoords cord : this.coords) {
                List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, Blocks.field_150348_b.func_149668_a(this.field_145850_b, cord.x, cord.y, cord.z));
                if (list.isEmpty()) continue;
                for (Object i : list) {
                    species.affectLiving((EntityLivingBase)i);
                }
            }
        }
    }

    private void useFood(ItemStack fish) {
        int usage = 0;
        FishSpecies species = Fishing.fishHelper.getSpecies(fish);
        if (species != null) {
            usage = Fish.foodUsage.getDNA(fish);
            usage = usage == 0 && species.requiresFood() ? 1 : usage;
        }
        this.drain(ForgeDirection.DOWN, Fluids.getFluidStack("fish_food", usage), true);
    }

    private void pickupFood() {
        for (CachedCoords coord : this.coords) {
            List list = this.field_145850_b.func_72872_a(EntityItem.class, Blocks.field_150348_b.func_149668_a(this.field_145850_b, coord.x, coord.y, coord.z));
            if (list.isEmpty()) continue;
            for (Object i : list) {
                EntityItem entity = (EntityItem)i;
                ItemStack item = entity.func_92059_d();
                if (!entity.func_70072_I() && (!entity.field_70170_p.field_73011_w.field_76575_d || !entity.func_70058_J()) || (item = this.addFishFood(item)) != null) continue;
                entity.func_70106_y();
            }
        }
    }

    private ItemStack addFishFood(ItemStack stack) {
        if (FishFoodHandler.isFishFood(stack)) {
            int increase = FishFoodHandler.getValue(stack);
            int loop = stack.field_77994_a;
            for (int i = 0; i < loop; ++i) {
                int fill = this.fill(ForgeDirection.UP, Fluids.getFluidStack("fish_food", increase), false);
                if (fill <= 0) continue;
                this.fill(ForgeDirection.UP, Fluids.getFluidStack("fish_food", increase), true);
                --stack.field_77994_a;
            }
        }
        if (stack.field_77994_a <= 0) {
            return null;
        }
        return stack;
    }

    @Override
    public boolean canWork() {
        return FeatureRedstone.RedstoneMode.canWork(this, this.mode) && this.hasMale() && this.hasFemale() && this.fishCanLive(this.inventory[5]) && this.fishCanLive(this.inventory[6]) && this.hasRoom(null);
    }

    private boolean hasMale() {
        return this.inventory[5] != null && Fishing.fishHelper.isMale(this.inventory[5]);
    }

    private boolean hasFemale() {
        return this.inventory[6] != null && Fishing.fishHelper.isFemale(this.inventory[6]);
    }

    private boolean fishCanLive(ItemStack fish) {
        FishSpecies species = Fishing.fishHelper.getSpecies(fish);
        if (species != null) {
            if (MaricultureHandlers.upgrades.hasUpgrade("debugLive", this)) {
                return true;
            }
            if (this.tank.getFluid() == null || this.tank.getFluid() != null && this.tank.getFluid().fluidID != Fluids.getFluidID("fish_food")) {
                return false;
            }
            return this.tankSize >= Fish.tankSize.getDNA(fish) && Fishing.fishHelper.canLive(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, fish);
        }
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        for (int slot = 0; slot < 2; ++slot) {
            FishSpecies species;
            if (this.inventory[slot] == null || (species = Fishing.fishHelper.getSpecies(this.inventory[slot])) == null) continue;
            return species.canConnectEnergy(from);
        }
        return false;
    }

    public int getLightValue() {
        int lM = 0;
        int lF = 0;
        FishSpecies sMale = Fishing.fishHelper.getSpecies(this.inventory[5]);
        FishSpecies sFemale = Fishing.fishHelper.getSpecies(this.inventory[6]);
        if (sMale != null && sMale.getLightValue() > 0) {
            lM = sMale.getLightValue();
        }
        if (sFemale != null && sFemale.getLightValue() > 0) {
            lF = sFemale.getLightValue();
        }
        if (lM == 0) {
            return lF;
        }
        if (lF == 0) {
            return lM;
        }
        return (lM + lF) / 2;
    }

    private boolean addToolTip(ArrayList<String> tooltip, String text) {
        tooltip.add("\u00a7c" + text);
        return false;
    }

    public Environment.Salinity getSalinity() {
        Environment.Salinity salt = MaricultureHandlers.environment.getSalinity(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        int salinity = salt.ordinal() + MaricultureHandlers.upgrades.getData("salinity", this);
        if (salinity <= 0) {
            salinity = 0;
        }
        if (salinity > 2) {
            salinity = 2;
        }
        salt = Environment.Salinity.values()[salinity];
        return salt;
    }

    public ArrayList<String> getTooltip(int slot, ArrayList<String> tooltip) {
        boolean noBad = true;
        ItemStack fish = this.inventory[slot];
        if (fish != null && fish.func_77942_o() && !Fishing.fishHelper.isEgg(fish) && fish.field_77990_d.func_74764_b("SpeciesID")) {
            int currentLife = fish.field_77990_d.func_74762_e("CurrentLife") / 20;
            if (!MaricultureHandlers.upgrades.hasUpgrade("debugLive", this)) {
                int size;
                int required;
                int temperature;
                FishSpecies species = FishSpecies.species.get(Fish.species.getDNA(fish));
                if (!MaricultureHandlers.upgrades.hasUpgrade("ethereal", this) && !species.isValidDimensionForWork(this.field_145850_b)) {
                    noBad = this.addToolTip(tooltip, Text.translate("badWorld"));
                }
                if ((temperature = MaricultureHandlers.environment.getTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) + this.heat) < species.temperature[0]) {
                    required = species.temperature[0] - temperature;
                    noBad = this.addToolTip(tooltip, Text.translate("tooCold"));
                    noBad = this.addToolTip(tooltip, "  +" + required + "\u00b0C");
                } else if (temperature > species.temperature[1]) {
                    required = temperature - species.temperature[1];
                    noBad = this.addToolTip(tooltip, Text.translate("tooHot"));
                    noBad = this.addToolTip(tooltip, "  -" + required + "\u00b0C");
                }
                boolean match = false;
                Environment.Salinity salt = this.getSalinity();
                for (Environment.Salinity salinity : species.salinity) {
                    if (salt != salinity) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    for (Environment.Salinity salinity : species.salinity) {
                        noBad = this.addToolTip(tooltip, Text.translate("salinity.prefers") + " " + Text.translate("salinity." + salinity.toString().toLowerCase()));
                    }
                }
                if (this.tankSize < (size = Fish.tankSize.getDNA(fish).intValue())) {
                    noBad = this.addToolTip(tooltip, Text.translate("notAdvanced"));
                    String text = this.field_145850_b.field_73011_w.field_76575_d ? Text.translate("blocks.lava") : Text.translate("blocks.water");
                    noBad = this.addToolTip(tooltip, "  +" + (size - this.tankSize) + " " + text);
                }
                if (!species.canWorkAtThisTime(this.isDay)) {
                    noBad = this.addToolTip(tooltip, Text.translate("badTime"));
                }
                if (!this.hasMale() || !this.hasFemale()) {
                    noBad = this.addToolTip(tooltip, Text.translate("missingMate"));
                }
                if (this.tank.getFluidAmount() < 1 || this.tank.getFluid().fluidID != Fluids.getFluidID("fish_food")) {
                    noBad = this.addToolTip(tooltip, Text.translate("noFood"));
                }
                if (noBad) {
                    tooltip.add("\u00a72" + currentLife + " HP");
                }
            } else if (this.hasMale() && this.hasFemale()) {
                tooltip.add("\u00a72" + currentLife + " HP");
            }
        }
        return tooltip;
    }

    public int getFishLifeScaled(ItemStack fish, int scale) {
        FishSpecies species = Fishing.fishHelper.getSpecies(fish);
        if (species != null && fish.func_77942_o()) {
            int gender = Fish.gender.getDNA(fish);
            int maxLife = fish.field_77990_d.func_74762_e("Lifespan");
            int currentLife = fish.field_77990_d.func_74762_e("CurrentLife");
            if (gender == FishyHelper.MALE && !this.hasFemale() || gender == FishyHelper.FEMALE && !this.hasMale()) {
                return -1;
            }
            if (this.fishCanLive(fish)) {
                return currentLife * scale / maxLife;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public void setGUIData(int id, int value) {
        if (id == 6) {
            this.tankSize = value;
        } else if (id == 7) {
            this.canWork = value == 1;
        } else if (id == 8) {
            this.isDay = value == 1;
        } else {
            super.setGUIData(id, value);
        }
    }

    @Override
    public ArrayList<Integer> getGUIData() {
        ArrayList<Integer> list = super.getGUIData();
        list.add(this.tankSize);
        list.add(this.canWork ? 1 : 0);
        list.add(this.field_145850_b.func_72935_r() ? 1 : 0);
        return list;
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        switch (type) {
            case NO_FOOD: {
                return this.tank.getFluid() == null || this.tank.getFluid() != null && this.tank.getFluid().fluidID != Fluids.getFluidID("fish_food");
            }
            case NO_MALE: {
                return !this.hasMale();
            }
            case NO_FEMALE: {
                return !this.hasFemale();
            }
            case BAD_ENV: {
                return (this.hasFemale() || this.hasMale()) && !this.canWork;
            }
        }
        return false;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tankSize = nbt.func_74762_e("TankSize");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("TankSize", this.tankSize);
    }
}

