/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import java.util.Random;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.config.Enchantments;
import mariculture.core.helpers.NBTHelper;
import mariculture.magic.Magic;
import mariculture.magic.ShapedJewelryRecipe;
import mariculture.magic.ShapelessJewelryRecipe;
import mariculture.magic.jewelry.ItemJewelry;
import mariculture.magic.jewelry.parts.JewelryBinding;
import mariculture.magic.jewelry.parts.JewelryMaterial;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class JewelryHandler {
    public static void addJewelry(ItemJewelry.JewelryType type, ItemStack result, ItemStack binding, ItemStack material, int hits) {
        if (type == ItemJewelry.JewelryType.RING) {
            JewelryHandler.addRing(result, binding, material, hits);
        } else if (type == ItemJewelry.JewelryType.BRACELET) {
            JewelryHandler.addBracelet(result, binding, material, hits);
        } else if (type == ItemJewelry.JewelryType.NECKLACE) {
            JewelryHandler.addNecklace(result, binding, material, hits);
        }
    }

    public static void addRing(ItemStack result, ItemStack binding, ItemStack material, int hits) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedJewelryRecipe(MaricultureHandlers.anvil.createWorkedItem(result, hits), "ABA", "A A", "AAA", Character.valueOf('A'), binding, Character.valueOf('B'), material));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessJewelryRecipe(MaricultureHandlers.anvil.createWorkedItem(result, hits / 3), material, result));
    }

    public static void addBracelet(ItemStack result, ItemStack binding, ItemStack material, int hits) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedJewelryRecipe(MaricultureHandlers.anvil.createWorkedItem(result, hits), "A A", "B B", " B ", Character.valueOf('A'), binding, Character.valueOf('B'), material));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessJewelryRecipe(MaricultureHandlers.anvil.createWorkedItem(result, hits / 3), material, result));
    }

    public static void addNecklace(ItemStack result, ItemStack binding, ItemStack material, int hits) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedJewelryRecipe(MaricultureHandlers.anvil.createWorkedItem(result, hits), "BAB", "B B", "BBB", Character.valueOf('A'), binding, Character.valueOf('B'), material));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessJewelryRecipe(MaricultureHandlers.anvil.createWorkedItem(result, hits / 3), material, result));
    }

    public static JewelryBinding getBinding(ItemStack stack) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("binding")) {
            return JewelryBinding.list.get(stack.field_77990_d.func_74779_i("binding"));
        }
        return Magic.dummyBinding;
    }

    public static JewelryMaterial getMaterial(ItemStack stack) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("material")) {
            return JewelryMaterial.list.get(stack.field_77990_d.func_74779_i("material"));
        }
        return Magic.dummyMaterial;
    }

    public static ItemJewelry.JewelryType getType(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemJewelry ? ((ItemJewelry)stack.func_77973_b()).getType() : ItemJewelry.JewelryType.NONE;
    }

    public static ItemStack createSpecial(ItemJewelry item, ItemJewelry.JewelryType accepted, String special) {
        ItemStack stack = new ItemStack((Item)item);
        if (JewelryHandler.getType(stack) == accepted) {
            stack.func_77982_d(new NBTTagCompound());
            stack.field_77990_d.func_74778_a("Specials", special);
            return stack;
        }
        return null;
    }

    public static ItemStack createJewelry(ItemJewelry item, JewelryBinding binding, JewelryMaterial material) {
        ItemStack stack = new ItemStack((Item)item);
        stack.func_77982_d(new NBTTagCompound());
        stack.field_77990_d.func_74778_a("binding", binding.getIdentifier());
        stack.field_77990_d.func_74778_a("material", material.getIdentifier());
        return stack;
    }

    public static int getLevel(ItemJewelry.JewelryType type, JewelryMaterial mat, JewelryBinding bind, int start) {
        return Math.min(start, Math.min(bind.getMaxEnchantmentLevel(type), mat.getMaximumEnchantmentLevel(type)));
    }

    public static boolean canApply(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemJewelry && stack.func_77942_o()) {
            if (Enchantments.ALLOW_MC_ANVIL) {
                int max;
                ItemJewelry.JewelryType type = JewelryHandler.getType(stack);
                JewelryMaterial material = JewelryHandler.getMaterial(stack);
                int current = EnchantmentHelper.func_82781_a((ItemStack)stack).size();
                return current < (max = type.getMaximumEnchantments() + material.getExtraEnchantments(type));
            }
            return false;
        }
        return true;
    }

    public static ItemStack finishJewelry(ItemStack stack, ItemStack result, Random rand) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("EnchantmentList") && stack.field_77990_d.func_74764_b("EnchantmentLevels")) {
            ItemJewelry.JewelryType type = JewelryHandler.getType(result);
            JewelryMaterial material = JewelryHandler.getMaterial(result);
            JewelryBinding binding = JewelryHandler.getBinding(result);
            int chance = binding.getKeepEnchantmentChance(type);
            int[] enchants = stack.field_77990_d.func_74759_k("EnchantmentList");
            int[] levels = stack.field_77990_d.func_74759_k("EnchantmentLevels");
            int total = 0;
            for (int j = 0; j < enchants.length; ++j) {
                if (rand.nextInt(100) >= chance || total >= type.getMaximumEnchantments() + material.getExtraEnchantments(type)) continue;
                ++total;
                Enchantment enchant = Enchantment.field_77331_b[enchants[j]];
                int level = JewelryHandler.getLevel(type, material, binding, levels[j]);
                int current = EnchantmentHelper.func_77506_a((int)enchant.field_77352_x, (ItemStack)result);
                if (current >= enchant.func_77325_b()) continue;
                int newLevel = JewelryHandler.getLevel(type, material, binding, current + level);
                if (current != 0) {
                    if (rand.nextInt(101 - chance) != 0) continue;
                    NBTTagList tagList = result.field_77990_d.func_150295_c("ench", 10);
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound tag = tagList.func_150305_b(i);
                        short id = tag.func_74765_d("id");
                        if (id != enchant.field_77352_x) continue;
                        tag.func_74777_a("lvl", (short)newLevel);
                        tagList.func_74744_a(i);
                        tagList.func_74742_a((NBTBase)tag);
                    }
                    continue;
                }
                result.func_77966_a(enchant, level);
            }
        }
        return result;
    }

    public static boolean match(ItemStack result, ItemStack stack) {
        if (result.field_77990_d == null || stack.field_77990_d == null) {
            return false;
        }
        ItemStack check1 = NBTHelper.getItemStackFromNBT(result.field_77990_d.func_74775_l("WorkedItem"));
        ItemStack check2 = NBTHelper.getItemStackFromNBT(stack.field_77990_d.func_74775_l("WorkedItem"));
        if (check1 == null || check1.func_77973_b() == null || check2 == null || check2.func_77973_b() == null) {
            return false;
        }
        return JewelryHandler.getBinding(check1) == JewelryHandler.getBinding(check2) && JewelryHandler.getMaterial(check1) == JewelryHandler.getMaterial(check2) && JewelryHandler.getType(check1) == JewelryHandler.getType(check2);
    }
}

