/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import mariculture.api.core.IMirrorHandler;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.network.PacketDamageJewelry;
import mariculture.core.network.PacketHandler;
import mariculture.core.network.PacketSyncMirror;
import mariculture.magic.JewelryHandler;
import mariculture.magic.Magic;
import mariculture.magic.MirrorHelper;
import mariculture.magic.jewelry.ItemJewelry;
import mariculture.magic.jewelry.parts.JewelryMaterial;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MirrorHandler
implements IMirrorHandler {
    @Override
    public boolean containsEnchantedItems(EntityPlayer player) {
        ItemStack[] mirror = MirrorHelper.getInventory(player);
        if (mirror != null) {
            for (int i = 0; i < 3; ++i) {
                if (mirror[i] == null || !mirror[i].func_77948_v() || EnchantHelper.isBroken(mirror[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void dropItems(EntityPlayer player, World world, double posX, double posY, double posZ) {
        ItemStack[] mirror = MirrorHelper.getInventory(player);
        for (int i = 0; i < mirror.length; ++i) {
            if (mirror[i] == null) continue;
            player.func_71019_a(mirror[i], true);
            mirror[i] = null;
        }
        MirrorHelper.save(player, mirror);
    }

    @Override
    public int getEnchantmentStrength(EntityPlayer player, int enchant) {
        ItemStack[] mirror = MirrorHelper.getInventory(player);
        int total = 0;
        for (int i = 0; i < 3; ++i) {
            if (mirror[i] == null || EnchantHelper.isBroken(mirror[i])) continue;
            total += EnchantHelper.getLevel(enchant, mirror[i]);
        }
        return total;
    }

    @Override
    public boolean hasEnchantment(EntityPlayer player, int enchant) {
        ItemStack[] mirror = MirrorHelper.getInventory(player);
        for (int i = 0; i < 3; ++i) {
            if (mirror[i] == null || !EnchantHelper.hasEnchantment(enchant, mirror[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack[] getMirrorContents(EntityPlayer player) {
        return MirrorHelper.getInventory(player);
    }

    @Override
    public void setMirrorContents(EntityPlayer player, ItemStack[] inventory) {
        MirrorHelper.save(player, inventory);
    }

    @Override
    public void damageItemsWithEnchantment(EntityPlayer player, int enchant, int amount) {
        if (player.field_70170_p.field_72995_K && player instanceof EntityClientPlayerMP) {
            PacketHandler.sendToServer(new PacketDamageJewelry(enchant, amount));
        } else {
            MirrorHandler.handleDamage(player, enchant, amount);
        }
    }

    public static void handleDamage(EntityPlayer player, int enchant, int amount) {
        int matId = amount;
        amount = EnchantHelper.exists(Magic.elemental) && enchant == Magic.elemental.field_77352_x ? 1 : amount;
        ItemStack[] mirror = MirrorHelper.getInventory(player);
        for (int damaged = 0; damaged < amount; ++damaged) {
            for (int i = 0; i < 3; ++i) {
                if (mirror[i] == null || !EnchantHelper.hasEnchantment(enchant, mirror[i])) continue;
                if (EnchantHelper.exists(Magic.elemental) && enchant == Magic.elemental.field_77352_x) {
                    JewelryMaterial material = JewelryHandler.getMaterial(mirror[i]);
                    if (material.id != matId || !mirror[i].func_96631_a(1, player.field_70170_p.field_73012_v)) continue;
                    PacketHandler.sendToClient(new PacketSyncMirror(MirrorHelper.getInventoryForPlayer(player)), (EntityPlayerMP)player);
                    continue;
                }
                if (!mirror[i].func_96631_a(1, player.field_70170_p.field_73012_v)) continue;
                PacketHandler.sendToClient(new PacketSyncMirror(MirrorHelper.getInventoryForPlayer(player)), (EntityPlayerMP)player);
            }
        }
        MirrorHelper.save(player, mirror);
    }

    @Override
    public boolean isJewelry(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemJewelry;
    }
}

