/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic.enchantments;

import mariculture.api.core.MaricultureHandlers;
import mariculture.core.config.Enchantments;
import mariculture.core.helpers.EnchantHelper;
import mariculture.magic.Magic;
import mariculture.magic.enchantments.EnchantmentJewelry;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class EnchantmentResurrection
extends EnchantmentJewelry {
    public static final String spawnX = "ResurrectionSpawnX";
    public static final String spawnY = "ResurrectionSpawnY";
    public static final String spawnZ = "ResurrectionSpawnZ";
    public static final String armor = "ResurrectionArmorList";
    public static final String inventory = "ResurrectionInventoryList";
    public static final String resistTime = "ResurrectionResistTime";

    public EnchantmentResurrection(int i, int weight, EnumEnchantmentType type) {
        super(i, weight, type);
        this.func_77322_b("resurrection");
        this.minLevel = 50;
        this.maxLevel = 55;
    }

    public int func_77325_b() {
        return 3;
    }

    public static void activate(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (EnchantHelper.hasEnchantment(Magic.resurrection, player) && !player.field_70170_p.field_72995_K) {
                if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
                    player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
                }
                if (!event.source.func_76347_k() && !event.source.func_76357_e() && EnchantHelper.getEnchantStrength(Magic.resurrection, player) > 1) {
                    player.getEntityData().func_74775_l("PlayerPersisted").func_74768_a(spawnX, (int)player.field_70165_t);
                    player.getEntityData().func_74775_l("PlayerPersisted").func_74768_a(spawnY, (int)player.field_70163_u);
                    player.getEntityData().func_74775_l("PlayerPersisted").func_74768_a(spawnZ, (int)player.field_70161_v);
                }
                if (EnchantHelper.getEnchantStrength(Magic.resurrection, player) > 2) {
                    int modifier = EnchantHelper.getEnchantStrength(Magic.resurrection, player);
                    player.getEntityData().func_74775_l("PlayerPersisted").func_74768_a(resistTime, 50 * modifier);
                }
                ItemStack[] inv = player.field_71071_by.field_70462_a;
                NBTTagList nbttaglist = new NBTTagList();
                for (int i = 0; i < inv.length; ++i) {
                    if (inv[i] == null) continue;
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    nbttagcompound1.func_74774_a("Slot", (byte)i);
                    inv[i].func_77955_b(nbttagcompound1);
                    nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
                }
                player.getEntityData().func_74775_l("PlayerPersisted").func_74782_a(inventory, (NBTBase)nbttaglist);
                ItemStack[] arm = player.field_71071_by.field_70460_b;
                NBTTagList armorList = new NBTTagList();
                for (int i = 0; i < arm.length; ++i) {
                    if (arm[i] == null) continue;
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    nbttagcompound1.func_74774_a("Slot", (byte)i);
                    arm[i].func_77955_b(nbttagcompound1);
                    armorList.func_74742_a((NBTBase)nbttagcompound1);
                }
                player.getEntityData().func_74775_l("PlayerPersisted").func_74782_a(armor, (NBTBase)armorList);
                event.setCanceled(true);
            } else if (Enchantments.Jewelry.DROP_JEWELRY && !player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                MaricultureHandlers.mirror.dropItems(player, player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
        }
    }
}

