/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic.jewelry.parts;

import java.util.HashMap;
import mariculture.magic.jewelry.ItemJewelry;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;

public abstract class JewelryMaterial {
    public static final String nbt = "material";
    public static final HashMap<String, JewelryMaterial> list = new HashMap();
    public final HashMap<ItemJewelry.JewelryType, IIcon> icons = new HashMap();
    public boolean ignore;
    public int id = list.size();

    public JewelryMaterial() {
        list.put(this.getIdentifier(), this);
    }

    public String getIdentifier() {
        String name = this.getClass().getSimpleName().substring(8);
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public int onHurt(LivingHurtEvent event, EntityPlayer player) {
        return 0;
    }

    public int onAttacked(LivingAttackEvent event, EntityPlayer player) {
        return 0;
    }

    public int onAttack(LivingAttackEvent event, EntityPlayer player) {
        return 0;
    }

    public int onKill(LivingDeathEvent event, EntityPlayer player) {
        return 0;
    }

    public int onBlockBreak(BlockEvent.HarvestDropsEvent event, EntityPlayer player) {
        return 0;
    }

    public IIcon getIcon(ItemJewelry.JewelryType type) {
        return this.icons.get((Object)type);
    }

    public void registerIcons(IIconRegister iconRegistry, ItemJewelry.JewelryType type) {
        this.icons.put(type, iconRegistry.func_94245_a("mariculture:jewelry/" + type.name().toLowerCase() + "/material/" + this.getIdentifier()));
    }

    public abstract int getExtraEnchantments(ItemJewelry.JewelryType var1);

    public abstract int getMaximumEnchantmentLevel(ItemJewelry.JewelryType var1);

    public abstract float getRepairModifier(ItemJewelry.JewelryType var1);

    public abstract float getDurabilityModifier(ItemJewelry.JewelryType var1);

    public abstract ItemStack getCraftingItem(ItemJewelry.JewelryType var1);

    public abstract String getColor();

    public abstract float getHitsModifier(ItemJewelry.JewelryType var1);
}

