/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import WayofTime.alchemicalWizardry.api.bindingRegistry.BindingRegistry;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.common.items.BoundArmour;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.Loot;
import mariculture.api.fishery.RodType;
import mariculture.api.util.Text;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.lib.Modules;
import mariculture.core.util.Fluids;
import mariculture.fishery.Fishery;
import mariculture.magic.Magic;
import mariculture.plugins.Plugins;
import mariculture.plugins.bloodmagic.BloodRodType;
import mariculture.plugins.bloodmagic.ItemBoundRod;
import mariculture.plugins.bloodmagic.ItemMobMagnetBloodEdition;
import mariculture.plugins.bloodmagic.RitualOfTheBloodRiver;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;

public class PluginBloodMagic
extends Plugins.Plugin {
    public static final RodType BLOOD = new BloodRodType(95, 15.0, 20.0, 5.0, 45);
    public static Item rodBlood;
    public static ItemStack demonBloodShard;
    public static ItemStack weakBloodShard;

    public PluginBloodMagic(String name) {
        super(name);
    }

    @Override
    public void preInit() {
        Fluids.add("blood", FluidRegistry.getFluid((String)"life essence"), 250, true);
        rodBlood = new ItemBoundRod().func_77655_b("rodBlood");
        RegistryHelper.registerItems(new Item[]{rodBlood});
        Fishing.fishing.registerRod(rodBlood, BLOOD);
    }

    private ItemStack getUndamaged(String str) {
        return this.getItem(str, 0);
    }

    @Override
    public void init() {
        if (Modules.isActive(Modules.fishery)) {
            demonBloodShard = this.getUndamaged("demonBloodShard");
            weakBloodShard = this.getUndamaged("weakBloodShard");
            Fishing.fishing.addBait(new ItemStack(Items.field_151078_bh), 35);
            Fishing.fishing.addBait(weakBloodShard, 75);
            Fishing.fishing.addBait(demonBloodShard, 100);
            Fishing.fishing.addBaitForQuality(new ItemStack(Items.field_151078_bh), BLOOD);
            Fishing.fishing.addBaitForQuality(weakBloodShard, BLOOD);
            Fishing.fishing.addBaitForQuality(demonBloodShard, BLOOD);
            this.addLoot(this.getUndamaged("blankSlate"), Loot.Rarity.JUNK, 10.0);
            this.addLoot(new ItemStack(Blocks.field_150321_G), Loot.Rarity.JUNK, 10.0);
            this.addLoot(this.getItem("baseItems", 3), Loot.Rarity.GOOD, 10.0);
            this.addLoot(this.getItem("baseAlchemyItems", 5), Loot.Rarity.GOOD, 10.0);
            this.addLoot(this.getUndamaged("simpleCatalyst"), Loot.Rarity.GOOD, 7.0);
            this.addLoot(this.getItem("baseItems", 0), Loot.Rarity.GOOD, 7.0);
            this.addLoot(this.getUndamaged("weakFillingAgent"), Loot.Rarity.JUNK, 15.0);
            this.addLoot(this.getItem("baseAlchemyItems", 3), Loot.Rarity.JUNK, 15.0);
            this.addLoot(this.getItem("baseItems", 1), Loot.Rarity.GOOD, 15.0);
            this.addLoot(this.getUndamaged("reinforcedSlate"), Loot.Rarity.JUNK, 20.0);
            this.addLoot(this.getUndamaged("alchemyFlask"), Loot.Rarity.GOOD, 40.0);
            this.addLoot(this.getUndamaged("standardFillingAgent"), Loot.Rarity.JUNK, 50.0);
            this.addLoot(this.getUndamaged("aether"), Loot.Rarity.GOOD, 50.0);
            this.addLoot(this.getItem("baseAlchemyItems", 4), Loot.Rarity.GOOD, 45.0);
            this.addLoot(this.getItem("baseItems", 4), Loot.Rarity.GOOD, 45.0);
            this.addLoot(this.getUndamaged("imbuedSlate"), Loot.Rarity.JUNK, 75.0);
            this.addLoot(this.getUndamaged("enhancedFillingAgent"), Loot.Rarity.GOOD, 75.0);
            this.addLoot(this.getUndamaged("itemKeyOfDiablo"), Loot.Rarity.GOOD, 75.0);
            ItemStack loot = this.getUndamaged("boundBoots");
            loot.func_77982_d(new NBTTagCompound());
            ((BoundArmour)loot.func_77973_b()).saveInternalInventory(loot, new ItemStack[9]);
            this.addLoot(loot, Loot.Rarity.GOOD, 200.0);
            Rituals.ritualList.add(new Rituals(1, 50000, (RitualEffect)new RitualOfTheBloodRiver(), Text.translate("ritual")));
            BindingRegistry.registerRecipe((ItemStack)new ItemStack(rodBlood), (ItemStack)new ItemStack(Fishery.rodTitanium));
        }
        if (Modules.isActive(Modules.magic)) {
            Magic.magnet = new ItemMobMagnetBloodEdition(0).func_77655_b("mobMagnet");
        }
    }

    private void addLoot(ItemStack stack, Loot.Rarity rarity, double chance) {
        Fishing.fishing.addLoot(new Loot(stack, chance, rarity, Short.MAX_VALUE, BLOOD, true));
    }

    @Override
    public void postInit() {
    }
}

