/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins.bloodmagic;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mariculture.api.fishery.Fishing;
import mariculture.core.config.FishMechanics;
import mariculture.core.helpers.BlockHelper;
import mariculture.fishery.items.ItemFishy;
import mariculture.fishery.items.ItemRod;
import mariculture.plugins.PluginBloodMagic;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBoundRod
extends ItemRod {
    private IIcon passiveIcon;

    public int[] getShard(EntityPlayer player) {
        int left;
        int rightSlot;
        int currentSlot = player.field_71071_by.field_70461_c;
        int leftSlot = currentSlot - 1;
        if (leftSlot == -1) {
            leftSlot = 8;
        }
        if ((rightSlot = currentSlot + 1) == 8) {
            rightSlot = 0;
        }
        if ((left = this.hasDemonShard(player, leftSlot)) > 0) {
            return new int[]{leftSlot, left};
        }
        int right = this.hasDemonShard(player, rightSlot);
        if (right > 0) {
            return new int[]{rightSlot, right};
        }
        return null;
    }

    public int hasDemonShard(EntityPlayer player, int slot) {
        ItemStack stack = player.field_71071_by.func_70301_a(slot);
        if (stack != null) {
            return stack.func_77973_b() == PluginBloodMagic.weakBloodShard.func_77973_b() ? FishMechanics.WEAK_FISH_LIMIT : (stack.func_77973_b() == PluginBloodMagic.demonBloodShard.func_77973_b() ? FishMechanics.DEMON_FISH_LIMIT : -1);
        }
        return -1;
    }

    private int catchFish(World world, EntityPlayer player, int maximum) {
        boolean lightning = false;
        int catches = 0;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    int x2 = (int)((double)x + player.field_70165_t);
                    int y2 = (int)((double)y + player.field_70163_u);
                    int z2 = (int)((double)z + player.field_70161_v);
                    if (!lightning && world.field_73012_v.nextInt(2048) == 0) {
                        lightning = true;
                        world.func_72942_c((Entity)new EntityLightningBolt(world, (double)x2, (double)y2, (double)z2));
                    }
                    if (!BlockHelper.isWater(world, x2, y2, z2) || world.field_73012_v.nextInt(5) != 0) continue;
                    ItemStack loot = Fishing.fishing.getCatch(world, x2, y2, z2, player, player.func_71045_bC());
                    if (!world.field_72995_K && loot != null) {
                        float f = 0.7f;
                        double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        EntityItem entityitem = new EntityItem(world, (double)x2 + d0, (double)y2 + d1, (double)z2 + d2, loot);
                        entityitem.field_70159_w = (double)(world.field_73012_v.nextFloat() * f) * 0.0;
                        entityitem.field_70181_x = world.field_73012_v.nextFloat() * f * 1.5f;
                        entityitem.field_70179_y = (double)(world.field_73012_v.nextFloat() * f) * 0.0;
                        if (loot.func_77973_b() instanceof ItemFishy) {
                            entityitem.lifespan = 60;
                        }
                        entityitem.field_145804_b = 0;
                        world.func_72838_d((Entity)entityitem);
                        player.func_71064_a(StatList.field_75933_B, 1);
                        player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(world, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v + 0.5, world.field_73012_v.nextInt(6) + 1));
                    }
                    if (++catches <= maximum) continue;
                    return catches;
                }
            }
        }
        return catches;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        SoulNetworkHandler.checkAndSetItemOwner((ItemStack)stack, (EntityPlayer)player);
        if (player.func_70644_a(AlchemicalWizardry.customPotionInhibit)) {
            return stack;
        }
        if (player.func_70093_af()) {
            this.setActivated(stack, !this.getActivated(stack));
            stack.field_77990_d.func_74768_a("worldTimeDelay", (int)(world.func_72820_D() - 1L) % 200);
        } else {
            if (!this.getActivated(stack)) {
                return Fishing.fishing.handleRightClick(stack, world, player);
            }
            int[] nums = this.getShard(player);
            if (nums != null) {
                int slot = nums[0];
                int count = nums[1];
                int catches = this.catchFish(world, player, count);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70298_a(slot, 1);
                }
                SoulNetworkHandler.syphonAndDamageFromNetwork((ItemStack)stack, (EntityPlayer)player, (int)(500 * catches));
            }
        }
        return stack;
    }

    public void setActivated(ItemStack stack, boolean newActivated) {
        NBTTagCompound nbt = stack.field_77990_d;
        if (nbt == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        nbt.func_74757_a("isActive", newActivated);
    }

    public boolean getActivated(ItemStack stack) {
        NBTTagCompound nbt = stack.field_77990_d;
        if (nbt == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return nbt.func_74767_n("isActive");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add("Let the rivers flow red with blood");
        if (stack.field_77990_d != null) {
            if (stack.field_77990_d.func_74767_n("isActive")) {
                list.add("Activated");
            } else {
                list.add("Deactivated");
            }
            if (!stack.field_77990_d.func_74779_i("ownerName").equals("")) {
                list.add("Current owner: " + stack.field_77990_d.func_74779_i("ownerName"));
            }
        }
        super.func_77624_a(stack, player, list, bool);
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 7.0, 0));
        return multimap;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tag;
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tag = stack.field_77990_d).func_74767_n("isActive")) {
            return this.field_77791_bV;
        }
        return this.passiveIcon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.passiveIcon = iconRegister.func_94245_a("mariculture:rodBlood_deactivated");
    }
}

