/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins.nei;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mariculture.aesthetics.Aesthetics;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.Core;
import mariculture.core.config.FishMechanics;
import mariculture.core.config.GeneralStuff;
import mariculture.core.lib.Modules;
import mariculture.factory.Factory;
import mariculture.fishery.Fishery;
import mariculture.magic.JewelryHandler;
import mariculture.magic.Magic;
import mariculture.magic.jewelry.ItemJewelry;
import mariculture.magic.jewelry.parts.JewelryBinding;
import mariculture.magic.jewelry.parts.JewelryMaterial;
import mariculture.plugins.nei.NEIAnvilRecipeHandler;
import mariculture.plugins.nei.NEIBlockCasterRecipeHandler;
import mariculture.plugins.nei.NEICrucibleRecipeHandler;
import mariculture.plugins.nei.NEIFishBreedingMutationHandler;
import mariculture.plugins.nei.NEIFishProductHandler;
import mariculture.plugins.nei.NEIIngotCasterRecipeHandler;
import mariculture.plugins.nei.NEIJewelryShapedHandler;
import mariculture.plugins.nei.NEINuggetCasterRecipeHandler;
import mariculture.plugins.nei.NEISifterRecipeHandler;
import mariculture.plugins.nei.NEIVatRecipeHandler;
import mariculture.world.WorldPlus;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class NEIConfig
implements IConfigureNEI {
    public static final HashMap<String, ArrayList<ItemStack>> containers = new HashMap();

    public void loadConfig() {
        FluidContainerRegistry.FluidContainerData[] data;
        int i;
        for (i = 0; i < 24; ++i) {
            API.addItemListEntry((ItemStack)new ItemStack(Core.crafting, 1, i));
        }
        for (i = 0; i < 39; ++i) {
            API.addItemListEntry((ItemStack)new ItemStack(Core.materials, 1, i));
        }
        for (i = 0; i < 16; ++i) {
            if (i >= 13 && Modules.isActive(Modules.worldplus)) {
                API.hideItem((ItemStack)new ItemStack(WorldPlus.plantGrowable, 1, i));
                API.hideItem((ItemStack)new ItemStack(WorldPlus.plantStatic, 1, i));
            }
            if (i >= 14) {
                API.hideItem((ItemStack)new ItemStack(Core.food, 1, i));
            }
            if (i >= 1) {
                API.hideItem((ItemStack)new ItemStack(Core.glass, 1, i));
            }
            if (i >= 1) {
                API.hideItem((ItemStack)new ItemStack(Core.transparent, 1, i));
            }
            if (i >= 1) {
                API.hideItem((ItemStack)new ItemStack(Core.water, 1, i));
            }
            if (i >= 2) {
                API.hideItem((ItemStack)new ItemStack(Core.sands, 1, i));
            }
            if (i >= 3) {
                API.hideItem((ItemStack)new ItemStack(Core.woods, 1, i));
            }
            if (i >= 6) {
                API.hideItem((ItemStack)new ItemStack(Core.metals, 1, i));
            }
            if (i >= 3) {
                API.hideItem((ItemStack)new ItemStack(Core.machinesMulti, 1, i));
            }
            if (i >= 5) {
                API.hideItem((ItemStack)new ItemStack(Core.tanks, 1, i));
            }
            if (i >= 5) {
                API.hideItem((ItemStack)new ItemStack(Core.renderedMachinesMulti, 1, i));
            }
            if (i >= 5) {
                API.hideItem((ItemStack)new ItemStack(Core.rocks, 1, i));
            }
            if (i >= 10) {
                API.hideItem((ItemStack)new ItemStack(Core.machines, 1, i));
            }
            if (i >= 12) {
                API.hideItem((ItemStack)new ItemStack(Core.renderedMachines, 1, i));
            }
            if (i < 12) continue;
            API.hideItem((ItemStack)new ItemStack(Core.pearlBlock, 1, i));
            if (Modules.isActive(Modules.aesthetics)) {
                API.hideItem((ItemStack)new ItemStack(Aesthetics.pearlBrick, 1, i));
            }
            if (!Modules.isActive(Modules.fishery)) continue;
            API.hideItem((ItemStack)new ItemStack(Fishery.lampsOn, 1, i));
        }
        API.hideItem((ItemStack)new ItemStack(Core.tanks, 1, 2));
        API.hideItem((ItemStack)new ItemStack(Core.limestone, 1, 8));
        API.hideItem((ItemStack)new ItemStack(Core.limestone, 1, 9));
        API.hideItem((ItemStack)new ItemStack(Core.limestone, 1, 11));
        API.hideItem((ItemStack)new ItemStack(Core.limestone, 1, 12));
        API.hideItem((ItemStack)new ItemStack(Core.limestone, 1, 13));
        API.hideItem((ItemStack)new ItemStack(Core.limestone, 1, 14));
        API.hideItem((ItemStack)new ItemStack(Core.limestone, 1, 15));
        for (i = 15; i <= 26; ++i) {
            API.hideItem((ItemStack)new ItemStack(Core.materials, 1, i));
        }
        if (Modules.isActive(Modules.fishery)) {
            API.registerRecipeHandler((ICraftingHandler)new NEIFishProductHandler());
            API.registerUsageHandler((IUsageHandler)new NEIFishProductHandler());
            API.hideItem((ItemStack)new ItemStack(Fishery.lampsOff, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(Fishery.fishEggs, 1, Short.MAX_VALUE));
            API.registerRecipeHandler((ICraftingHandler)new NEISifterRecipeHandler());
            API.registerUsageHandler((IUsageHandler)new NEISifterRecipeHandler());
            API.registerRecipeHandler((ICraftingHandler)new NEIFishBreedingMutationHandler());
            API.registerUsageHandler((IUsageHandler)new NEIFishBreedingMutationHandler());
            if (FishMechanics.DISABLE_FISH) {
                API.hideItem((ItemStack)new ItemStack(Fishery.fishy));
            } else {
                for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
                    FishSpecies fishy = species.getValue();
                    ItemStack fish = Fishing.fishHelper.makePureFish(fishy);
                    API.addItemListEntry((ItemStack)fish);
                }
            }
        }
        API.registerRecipeHandler((ICraftingHandler)new NEICrucibleRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEICrucibleRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIVatRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEIVatRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIAnvilRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEIAnvilRecipeHandler());
        if (GeneralStuff.SHOW_CASTER_RECIPES) {
            API.registerRecipeHandler((ICraftingHandler)new NEIIngotCasterRecipeHandler());
            API.registerUsageHandler((IUsageHandler)new NEIIngotCasterRecipeHandler());
            API.registerRecipeHandler((ICraftingHandler)new NEIBlockCasterRecipeHandler());
            API.registerUsageHandler((IUsageHandler)new NEIBlockCasterRecipeHandler());
            API.registerRecipeHandler((ICraftingHandler)new NEINuggetCasterRecipeHandler());
            API.registerUsageHandler((IUsageHandler)new NEINuggetCasterRecipeHandler());
        }
        API.hideItem((ItemStack)new ItemStack(Core.air, 1, Short.MAX_VALUE));
        API.hideItem((ItemStack)new ItemStack(Core.ticking, 1, Short.MAX_VALUE));
        API.hideItem((ItemStack)new ItemStack(Core.worked, 1, Short.MAX_VALUE));
        for (int i2 = 5; i2 <= 7; ++i2) {
            API.hideItem((ItemStack)new ItemStack(Core.renderedMachines, 1, i2));
        }
        if (Modules.isActive(Modules.factory)) {
            API.hideItem((ItemStack)new ItemStack(Factory.customBlock, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(Factory.customFence, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(Factory.customFlooring, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(Factory.customGate, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(Factory.customLight, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(Factory.customRFBlock, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(Factory.customSlabs, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(Factory.customSlabsDouble, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(Factory.customStairs, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(Factory.customWall, 1, Short.MAX_VALUE));
        }
        for (FluidContainerRegistry.FluidContainerData container : data = (FluidContainerRegistry.FluidContainerData[])FluidContainerRegistry.getRegisteredFluidContainerData().clone()) {
            ArrayList<Object> list;
            String fluid = container.fluid.getFluid().getName();
            if (containers.containsKey("fluid")) {
                list = containers.get(fluid);
                list.add(container.filledContainer);
                continue;
            }
            list = new ArrayList();
            list.add(container.filledContainer);
            containers.put(fluid, list);
        }
        if (Modules.isActive(Modules.magic)) {
            API.registerRecipeHandler((ICraftingHandler)new NEIJewelryShapedHandler());
            API.registerUsageHandler((IUsageHandler)new NEIJewelryShapedHandler());
            this.addJewelry((ItemJewelry)Magic.ring);
            this.addJewelry((ItemJewelry)Magic.bracelet);
            this.addJewelry((ItemJewelry)Magic.necklace);
        }
    }

    private void addJewelry(ItemJewelry item) {
        ItemJewelry.JewelryType type = item.getType();
        for (Map.Entry<String, JewelryBinding> binding : JewelryBinding.list.entrySet()) {
            if (binding.getValue().ignore) continue;
            for (Map.Entry<String, JewelryMaterial> material : JewelryMaterial.list.entrySet()) {
                if (material.getValue().ignore) continue;
                JewelryBinding bind = binding.getValue();
                JewelryMaterial mat = material.getValue();
                ItemStack worked = JewelryHandler.createJewelry(item, bind, mat);
                ItemStack output = JewelryHandler.createJewelry(item, binding.getValue(), material.getValue());
                int hits = (int)((float)bind.getHitsBase(type) * mat.getHitsModifier(type));
                NEIAnvilRecipeHandler.jewelry.put(output, new NEIAnvilRecipeHandler.RecipeJewelry(MaricultureHandlers.anvil.createWorkedItem(worked, hits), hits));
            }
        }
    }

    public String getName() {
        return "Mariculture NEI";
    }

    public String getVersion() {
        return "1.0";
    }
}

