/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.RecipeSifter;
import mariculture.core.helpers.OreDicHelper;
import mariculture.plugins.nei.NEIBase;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class NEISifterRecipeHandler
extends NEIBase {
    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("sifter") && ((Object)((Object)this)).getClass() == NEISifterRecipeHandler.class) {
            HashMap<List<? extends Object>, ArrayList<RecipeSifter>> recipes = Fishing.sifter.getRecipes();
            for (Map.Entry<List<? extends Object>, ArrayList<RecipeSifter>> recipe : recipes.entrySet()) {
                this.arecipes.add(new CachedSifterRecipe(null, recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        HashMap<List<? extends Object>, ArrayList<RecipeSifter>> recipes = Fishing.sifter.getRecipes();
        for (Map.Entry<List<? extends Object>, ArrayList<RecipeSifter>> recipe : recipes.entrySet()) {
            for (RecipeSifter sifter : recipe.getValue()) {
                if (!OreDicHelper.convert(sifter.bait).equals(OreDicHelper.convert(result))) continue;
                this.arecipes.add(new CachedSifterRecipe(null, recipe.getValue()));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList<RecipeSifter> recipes = Fishing.sifter.getResult(ingredient);
        if (recipes != null) {
            this.arecipes.add(new CachedSifterRecipe(ingredient, recipes));
        }
    }

    public void drawExtras(int id) {
        CachedSifterRecipe cache = (CachedSifterRecipe)((Object)this.arecipes.get(id));
        for (SifterResult recipe : cache.outputs) {
            GL11.glPushMatrix();
            GL11.glScalef((float)0.9f, (float)0.9f, (float)0.9f);
            Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a77" + recipe.recipe.chance + "%", 78 + recipe.id * 21, 38, 0);
            GL11.glPopMatrix();
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)65);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(39, 16, 22, 16), "sifter", new Object[0]));
    }

    public String getRecipeName() {
        return "Sifter";
    }

    @Override
    public boolean isOverItem(GuiRecipe gui, int id) {
        return false;
    }

    public String getGuiTexture() {
        return new ResourceLocation("mariculture", "textures/gui/nei/sifter.png").toString();
    }

    public String getOverlayIdentifier() {
        return "sifter";
    }

    public class CachedSifterRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        List<PositionedStack> inputs;
        List<SifterResult> outputs;

        public CachedSifterRecipe(ItemStack input, ArrayList<RecipeSifter> output) {
            super((TemplateRecipeHandler)NEISifterRecipeHandler.this);
            this.inputs = new ArrayList<PositionedStack>();
            if (input == null) {
                this.inputs = this.generateList(output);
            } else {
                this.inputs.add(new PositionedStack((Object)input, 12, 16));
            }
            this.outputs = new ArrayList<SifterResult>();
            int x = 0;
            for (RecipeSifter recipe : output) {
                this.outputs.add(new SifterResult(recipe, x));
                ++x;
            }
        }

        private List<PositionedStack> generateList(ArrayList<RecipeSifter> output) {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            ItemStack stack = output.get((int)0).block;
            if (stack.func_77960_j() == Short.MAX_VALUE) {
                List permutations = ItemList.itemMap.get((Object)stack.func_77973_b());
                if (!permutations.isEmpty()) {
                    for (ItemStack stack2 : permutations) {
                        list.add(new PositionedStack((Object)stack2.func_77946_l(), 12, 16));
                    }
                } else {
                    ItemStack base = new ItemStack(stack.func_77973_b(), stack.field_77994_a);
                    base.field_77990_d = stack.field_77990_d;
                    list.add(new PositionedStack((Object)base, 12, 16));
                }
            } else {
                list.add(new PositionedStack((Object)stack, 12, 16));
            }
            return list;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            for (SifterResult result : this.outputs) {
                stacks.add(result.getStack());
            }
            return stacks;
        }

        public PositionedStack getIngredient() {
            if (this.inputs == null || this.inputs.size() < 1) {
                return null;
            }
            return this.inputs.get(NEISifterRecipeHandler.this.cycleticks / 48 % this.inputs.size());
        }
    }

    public class SifterResult {
        int id;
        RecipeSifter recipe;
        public ArrayList<PositionedStack> stacks;

        public SifterResult(RecipeSifter recipe, int x) {
            this.id = x;
            this.stacks = new ArrayList();
            int i = recipe.minCount;
            while (i <= recipe.maxCount) {
                ItemStack bait = recipe.bait.func_77946_l();
                bait.field_77994_a = i++;
                this.stacks.add(new PositionedStack((Object)bait.func_77946_l(), 70 + x * 18, 15, false));
            }
            this.recipe = recipe;
        }

        public PositionedStack getStack() {
            return this.stacks.get(NEISifterRecipeHandler.this.cycleticks / 48 % this.stacks.size());
        }
    }
}

