/*
 * Decompiled with CFR 0.152.
 */
package mariculture.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.config.WorldGeneration;
import mariculture.core.handlers.WorldEventHandler;
import mariculture.world.decorate.WorldGenAncientSand;
import mariculture.world.decorate.WorldGenKelp;
import mariculture.world.decorate.WorldGenReef;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class GenerationHandler
implements IWorldGenerator {
    public static WorldGenReef coralGenerator = new WorldGenReef();
    public static WorldGenKelp kelpGenerator = new WorldGenKelp();
    public static WorldGenAncientSand sandGen = new WorldGenAncientSand();
    private static boolean isCoralReef = false;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!WorldEventHandler.isBlacklisted(world.field_73011_w.field_76574_g)) {
            try {
                Environment.Salinity salinity = MaricultureHandlers.environment.getSalinity(world, chunkX * 16, chunkZ * 16);
                if (salinity == Environment.Salinity.SALINE) {
                    GenerationHandler.generateAncientSand(world, random, chunkX * 16, chunkZ * 16);
                    GenerationHandler.generateCoralReef(world, random, chunkX * 16, chunkZ * 16);
                }
                if (salinity != Environment.Salinity.FRESH) {
                    GenerationHandler.generateKelpPlants(world, random, chunkX * 16, chunkZ * 16);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void generateAncientSand(World world, Random rand, int x, int z) {
        if (WorldGeneration.WorldGen.ANCIENT_SAND_ENABLED && rand.nextInt(Math.max(1, WorldGeneration.WorldGen.ANCIENT_SAND_CHANCE)) == 0) {
            int j = x + rand.nextInt(16) + 8;
            int k = z + rand.nextInt(16) + 8;
            sandGen.func_76484_a(world, rand, j, world.func_72825_h(j, k), k);
        }
    }

    public static void generateCoralReef(World world, Random rand, int x, int z) {
        if (WorldGeneration.WorldGen.CORAL_REEF_ENABLED) {
            if (!isCoralReef && rand.nextInt(WorldGeneration.WorldGen.CORAL_REEF_START_CHANCE) == 0) {
                isCoralReef = true;
            }
            if (isCoralReef && rand.nextInt(WorldGeneration.WorldGen.CORAL_REEF_END_CHANCE) == 0) {
                isCoralReef = false;
            }
            if (isCoralReef) {
                for (int i = 0; i < 5; ++i) {
                    coralGenerator.func_76484_a(world, rand, x + rand.nextInt(16) + 8, 64, z + rand.nextInt(16) + 8);
                }
            }
        }
    }

    public static void generateKelpPlants(World world, Random rand, int x, int z) {
        int k = x + rand.nextInt(16) + 8;
        int l = z + rand.nextInt(16) + 8;
        int i1 = rand.nextInt(world.func_72976_f(k, l) * 2);
        kelpGenerator.func_76484_a(world, rand, k, i1, l);
    }
}

