/*
 * Decompiled with CFR 0.152.
 */
package mariculture.api.fishery;

import java.util.LinkedList;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class RodType {
    public static final RodType NET = new RodType(0, 0.0, 0.0, 0.0, 0);
    public static final RodType DIRE = new RodType(10, 45.0, 0.0, 0.0, 5);
    public static final RodType OLD = new RodType(25, 27.5, 5.5, 0.0, 10);
    public static final RodType GOOD = new RodType(50, 10.0, 17.5, 1.0, 20);
    public static final RodType SUPER = new RodType(75, 1.0, 15.5, 5.0, 30);
    public static final RodType FLUX = new RodTypeFlux(90, 0.0, 13.0, 7.5, 15);
    private final LinkedList<Double> chances;
    private final int quality;
    private final int enchantment;

    public RodType(int quality, double junk, double good, double rare, int enchantment) {
        this.quality = quality;
        this.chances = new LinkedList();
        this.chances.add(junk);
        this.chances.add(good);
        this.chances.add(rare);
        this.enchantment = enchantment;
    }

    public LinkedList<Double> getChances() {
        return this.chances;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getLootEnchantmentChance() {
        return this.enchantment;
    }

    public float getDamage() {
        return 0.0f;
    }

    public boolean caughtAlive(String species) {
        return false;
    }

    public boolean canFish(World world, int posX, int posY, int posZ, EntityPlayer player, ItemStack stack) {
        return true;
    }

    public ItemStack damage(World world, EntityPlayer player, ItemStack stack, int fish, Random rand) {
        if (player != null) {
            stack.func_77972_a(fish, (EntityLivingBase)player);
        } else if (stack.func_96631_a(1, rand)) {
            stack = null;
        }
        return stack;
    }

    public boolean canUseBaitManually() {
        return true;
    }

    public boolean canDisplay(ItemStack stack) {
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RodType)) {
            return false;
        }
        return ((RodType)o).quality == this.quality;
    }

    public static class RodTypeFlux
    extends RodType {
        public RodTypeFlux(int quality, double junk, double good, double rare, int enchantment) {
            super(quality, junk, good, rare, enchantment);
        }

        @Override
        public boolean canFish(World world, int posX, int posY, int posZ, EntityPlayer player, ItemStack stack) {
            if (stack.func_77942_o()) {
                return stack.field_77990_d.func_74762_e("Energy") >= 100;
            }
            return false;
        }

        @Override
        public ItemStack damage(World world, EntityPlayer player, ItemStack stack, int fish, Random rand) {
            if (stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("Energy")) {
                return stack;
            }
            if (stack.field_77990_d.func_74762_e("Energy") <= 0) {
                return stack;
            }
            int energy = stack.field_77990_d.func_74762_e("Energy");
            int energyExtracted = Math.min(energy, 100);
            stack.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
            return stack;
        }
    }
}

