/*
 * Decompiled with CFR 0.152.
 */
package mariculture.api.fishery.fish;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishProduct;
import mariculture.api.util.CachedCoords;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class FishSpecies {
    public static boolean DISABLE_BIOME_CATCHING;
    public static boolean DISABLE_DIMENSION_CATCHING;
    public static final HashMap<Integer, FishSpecies> species;
    public static final HashMap<String, Integer> ids;
    private static final HashMap<String, ArrayList<FishProduct>> products;
    public int[] temperature;
    public Environment.Salinity[] salinity;
    public String modid;
    private IIcon theIcon;
    private IIcon altIcon;

    public final int getID() {
        return ids.get(this.getSpecies());
    }

    public final FishSpecies setup(String mod) {
        this.temperature = this.setSuitableTemperature();
        this.salinity = this.setSuitableSalinity();
        this.modid = mod;
        return this;
    }

    public String getSimpleName() {
        return this.getClass().getSimpleName().toLowerCase().substring(4);
    }

    public String getSpecies() {
        return this.modid + ":" + this.getSimpleName();
    }

    protected final boolean isAcceptedTemperature(int temp) {
        return temp >= this.temperature[0] && temp <= this.temperature[1];
    }

    public abstract int[] setSuitableTemperature();

    public abstract Environment.Salinity[] setSuitableSalinity();

    public boolean isLavaFish() {
        return false;
    }

    public ItemStack getRawForm(int stackSize) {
        return new ItemStack(Items.field_151115_aP, stackSize, this.getID());
    }

    public abstract boolean isDominant();

    public abstract int getLifeSpan();

    public abstract int getFertility();

    public int getBaseProductivity() {
        return 1;
    }

    public int getFoodConsumption() {
        return 1;
    }

    public boolean requiresFood() {
        return true;
    }

    public int getWaterRequired() {
        return 15;
    }

    public int getAreaOfEffectBonus(ForgeDirection dir) {
        return 0;
    }

    public final ArrayList<FishProduct> getProductList() {
        return products.get(this.getSpecies());
    }

    public abstract void addFishProducts();

    public final void addProduct(Block block, double chance) {
        this.addProduct(new ItemStack(block), chance);
    }

    public final void addProduct(Item item, double chance) {
        this.addProduct(new ItemStack(item), chance);
    }

    public final void addProduct(ItemStack stack, double chance) {
        String fish = this.getSpecies();
        ArrayList<Object> list = null;
        list = products.containsKey(fish) ? products.get(fish) : new ArrayList();
        if (list.size() < 15) {
            list.add(new FishProduct(stack.func_77946_l(), chance));
        }
        products.put(fish, list);
    }

    public final ItemStack getProduct(Random rand) {
        for (FishProduct product : products.get(this.getSpecies())) {
            int chance = (int)(product.chance * 10.0);
            if (rand.nextInt(1000) >= chance) continue;
            return product.product.func_77946_l();
        }
        return null;
    }

    public boolean destroyOnAttack() {
        return false;
    }

    public Multimap getModifiers(UUID uuid, Multimap multimap) {
        return multimap;
    }

    public String getPotionEffect(ItemStack stack) {
        return null;
    }

    public double getFishOilVolume() {
        return 0.166;
    }

    public ItemStack getLiquifiedProduct() {
        return new ItemStack(Items.field_151103_aS);
    }

    public int getLiquifiedProductChance() {
        return 10;
    }

    public int getFishMealSize() {
        return (int)Math.max(Math.floor(this.getFishOilVolume()), 1.0);
    }

    public int getFoodStat() {
        return (int)Math.ceil(this.getFishOilVolume());
    }

    public float getFoodSaturation() {
        return (float)(this.getFishOilVolume() / 10.0);
    }

    public int getFoodDuration() {
        return 32;
    }

    public boolean canAlwaysEat() {
        return false;
    }

    public void onConsumed(World world, EntityPlayer player) {
    }

    public ItemStack onRightClick(World world, EntityPlayer player, ItemStack stack, Random rand) {
        return stack;
    }

    public void affectWorld(World world, int x, int y, int z, ArrayList<CachedCoords> coords) {
    }

    public void affectLiving(EntityLivingBase entity) {
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return false;
    }

    public int getLightValue() {
        return 0;
    }

    public boolean isValidDimensionForWork(World world) {
        return true;
    }

    public boolean canWorkAtThisTime(boolean isDay) {
        return true;
    }

    public abstract RodType getRodNeeded();

    protected boolean isWorldCorrect(World world) {
        return !world.field_73011_w.field_76575_d && world.field_73011_w.field_76574_g != 1;
    }

    public double getCatchChance(World world, int x, int y, int z, Environment.Salinity salt, int temp) {
        if (!DISABLE_DIMENSION_CATCHING && !this.isWorldCorrect(world)) {
            return 0.0;
        }
        if (DISABLE_BIOME_CATCHING) {
            return this.getCatchChance(world, y);
        }
        return this.getCatchChance(world, salt, temp, y);
    }

    public double getCatchChance(World world, Environment.Salinity salt, int temp, int height) {
        return MaricultureHandlers.environment.matches(salt, temp, this.salinity, this.temperature) ? this.getCatchChance(world, height) : 0.0;
    }

    public double getCatchChance(World world, int height) {
        return 5.0;
    }

    public double getCaughtAliveChance(World world, int x, int y, int z, Environment.Salinity salt, int temp) {
        if (!DISABLE_DIMENSION_CATCHING && !this.isWorldCorrect(world)) {
            return 0.0;
        }
        if (DISABLE_BIOME_CATCHING) {
            return this.getCaughtAliveChance(world, y);
        }
        return this.getCaughtAliveChance(world, salt, temp, y);
    }

    public double getCaughtAliveChance(World world, Environment.Salinity salt, int temp, int height) {
        return this.isAcceptedTemperature(temp) && salt == this.salinity[0] ? this.getCaughtAliveChance(world, height) : 0.0;
    }

    public double getCaughtAliveChance(World world, int height) {
        return 0.0;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("fish.data.species." + this.getSimpleName()));
    }

    public boolean hasGenderIcons() {
        return false;
    }

    public IIcon getIcon(int gender) {
        return this.hasGenderIcons() && gender == 0 ? this.altIcon : this.theIcon;
    }

    public void registerIcon(IIconRegister iconRegister) {
        if (this.hasGenderIcons()) {
            this.theIcon = iconRegister.func_94245_a(this.modid + ":fish/" + this.getSimpleName() + "_female");
            this.altIcon = iconRegister.func_94245_a(this.modid + ":fish/" + this.getSimpleName() + "_male");
        } else {
            this.theIcon = iconRegister.func_94245_a(this.modid + ":fish/" + this.getSimpleName());
        }
    }

    static {
        species = new HashMap();
        ids = new HashMap();
        products = new HashMap();
    }
}

