/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mariculture.core.blocks.base.BlockDecorative;
import mariculture.core.lib.Modules;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLimestone
extends BlockDecorative {
    public BlockLimestone() {
        super(Material.field_151576_e);
        this.prefix = "limestone";
    }

    @Override
    public String getToolType(int meta) {
        return "pickaxe";
    }

    @Override
    public int getToolLevel(int meta) {
        return 0;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 0.75f;
            }
            case 1: {
                return 1.0f;
            }
            case 3: {
                return 1.75f;
            }
            case 4: {
                return 2.0f;
            }
        }
        return 1.5f;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        if (meta >= 7 && meta <= 9) {
            return side == 0 || side == 1 ? 7 : (side == 2 || side == 3 ? 8 : 9);
        }
        if (meta >= 10) {
            if (hitY >= 0.85f) {
                return 10;
            }
            if (hitY <= 0.15f) {
                return 11;
            }
            return side + 10;
        }
        return meta;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 7 && meta < 9) {
            world.func_72921_c(x, y, z, meta + 1, 2);
        } else if (meta == 9) {
            world.func_72921_c(x, y, z, 7, 2);
        } else if (meta >= 10 && meta < 15) {
            world.func_72921_c(x, y, z, meta + 1, 2);
        } else if (meta == 15) {
            world.func_72921_c(x, y, z, 10, 2);
        }
        return false;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 7) {
            return side == 0 || side == 1 ? this.icons[8] : this.icons[9];
        }
        if (meta == 8) {
            return side == 0 || side == 1 ? this.icons[9] : (side == 4 || side == 5 ? this.icons[7] : this.icons[8]);
        }
        if (meta == 9) {
            return side == 4 || side == 5 ? this.icons[8] : this.icons[7];
        }
        if (meta == 10) {
            return side == 0 ? this.icons[8] : (side == 1 ? this.icons[5] : this.icons[11]);
        }
        if (meta == 11) {
            return side == 1 ? this.icons[8] : (side == 0 ? this.icons[5] : this.icons[10]);
        }
        if (meta == 12) {
            return side == 3 ? this.icons[8] : (side == 2 ? this.icons[5] : (side == 0 || side == 1 ? this.icons[11] : this.icons[12]));
        }
        if (meta == 13) {
            return side == 2 ? this.icons[8] : (side == 3 ? this.icons[5] : (side == 0 || side == 1 ? this.icons[10] : this.icons[13]));
        }
        if (meta == 14) {
            return side == 5 ? this.icons[8] : (side == 4 ? this.icons[5] : this.icons[12]);
        }
        if (meta == 15) {
            return side == 4 ? this.icons[8] : (side == 5 ? this.icons[5] : this.icons[13]);
        }
        if (meta == 6) {
            return side < 2 ? this.icons[5] : super.func_149691_a(side, meta);
        }
        return super.func_149691_a(side, meta);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 7) {
            return super.getPickBlock(target, world, x, y, z);
        }
        if (meta < 10) {
            return new ItemStack((Block)this, 1, 7);
        }
        return new ItemStack((Block)this, 1, 10);
    }

    public boolean isReplaceableOreGen(World world, int x, int y, int z, Block target) {
        return false;
    }

    @Override
    public boolean isActive(int meta) {
        if (meta == 0) {
            return true;
        }
        if (Modules.isActive(Modules.aesthetics)) {
            return meta != 8 && meta != 9 && meta <= 10;
        }
        return false;
    }

    @Override
    public int getMetaCount() {
        return 16;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.getMetaCount() - 2];
        for (int i = 0; i < this.icons.length; ++i) {
            String name = this.getName(i);
            this.icons[i] = iconRegister.func_94245_a("mariculture:" + this.prefix + name.substring(0, 1).toUpperCase() + name.substring(1));
        }
    }
}

