/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.blocks.base.BlockFunctionalMulti;
import mariculture.core.lib.Modules;
import mariculture.core.tile.TileCrucible;
import mariculture.fishery.tile.TileIncubator;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMachineMulti
extends BlockFunctionalMulti {
    private IIcon[] crucibleIcons;
    private IIcon[] incubatorIcons;

    public BlockMachineMulti() {
        super(Material.field_76233_E);
    }

    @Override
    public String getToolType(int meta) {
        return "pickaxe";
    }

    @Override
    public int getToolLevel(int meta) {
        return 2;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 6.0f;
            }
            case 1: {
                return 10.0f;
            }
            case 2: {
                return 5.0f;
            }
        }
        return 5.0f;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return side < 2 && meta == 0 ? Core.rocks.func_149691_a(side, 4) : super.func_149691_a(side, meta);
    }

    public IIcon func_149673_e(IBlockAccess block, int x, int y, int z, int side) {
        if (side > 1) {
            TileEntity tile = block.func_147438_o(x, y, z);
            if (tile instanceof TileCrucible) {
                TileCrucible crucible = (TileCrucible)tile;
                if (crucible.master == null) {
                    return this.func_149691_a(side, 0);
                }
                if (crucible.isMaster()) {
                    return this.crucibleIcons[1];
                }
                return this.crucibleIcons[0];
            }
            if (tile instanceof TileIncubator && block.func_72805_g(x, y, z) != 1) {
                TileIncubator incubator = (TileIncubator)tile;
                if (incubator.master == null) {
                    return this.func_149691_a(side, 2);
                }
                if (incubator.facing == ForgeDirection.DOWN) {
                    return this.incubatorIcons[0];
                }
                return this.incubatorIcons[1];
            }
        }
        return super.func_149673_e(block, x, y, z, side);
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileCrucible();
            }
            case 1: {
                return new TileIncubator();
            }
            case 2: {
                return new TileIncubator();
            }
        }
        return null;
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 0: {
                return true;
            }
            case 1: {
                return Modules.isActive(Modules.fishery);
            }
            case 2: {
                return Modules.isActive(Modules.fishery);
            }
        }
        return true;
    }

    @Override
    public boolean isValidTab(CreativeTabs tab, int meta) {
        switch (meta) {
            case 1: {
                return tab == MaricultureTab.tabFishery;
            }
            case 2: {
                return tab == MaricultureTab.tabFishery;
            }
        }
        return tab == MaricultureTab.tabFactory;
    }

    @Override
    public int getMetaCount() {
        return 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.incubatorIcons = new IIcon[2];
        this.incubatorIcons[0] = iconRegister.func_94245_a("mariculture:incubatorBottom");
        this.incubatorIcons[1] = iconRegister.func_94245_a("mariculture:incubatorTopTop");
        this.crucibleIcons = new IIcon[2];
        this.crucibleIcons[0] = iconRegister.func_94245_a("mariculture:crucibleTop");
        this.crucibleIcons[1] = iconRegister.func_94245_a("mariculture:crucibleBottom");
    }
}

