/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.core.Core;
import mariculture.core.blocks.base.BlockFluid;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockPressurisedWater
extends BlockFluid {
    public static IIcon[] still;
    public static IIcon[] flowing;
    public static IIcon xp_still;
    public static IIcon xp_flow;
    private int tick;

    public BlockPressurisedWater(Fluid fluid, Material material) {
        super(fluid, material);
        this.quantaPerBlock = 16;
        this.quantaPerBlockFloat = 16.0f;
    }

    public FluidStack drain(World world, int x, int y, int z, boolean doDrain) {
        return null;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        ++this.tick;
        if (this.tick % 15 == 0 && !world.field_72995_K && world instanceof WorldServer) {
            int z2;
            ForgeDirection dir = ForgeDirection.values()[rand.nextInt(6)];
            int x2 = x + dir.offsetX;
            int y2 = y - rand.nextInt(2);
            Block block = world.func_147439_a(x2, y2, z2 = z + dir.offsetZ);
            if (block != null && !(block instanceof BlockPressurisedWater) && !block.hasTileEntity(world.func_72805_g(x2, y2, z2))) {
                float resistanceMax = Blocks.field_150348_b.getExplosionResistance((Entity)PlayerHelper.getFakePlayer(world), world, x2, y2, z2, 0.0, 0.0, 0.0);
                float resistance = block.getExplosionResistance((Entity)PlayerHelper.getFakePlayer(world), world, x2, y2, z2, 0.0, 0.0, 0.0);
                if (resistance <= resistanceMax) {
                    BlockHelper.destroyBlock(world, x2, y2, z2);
                }
            }
        }
    }

    public void func_149640_a(World world, int x, int y, int z, Entity entity, Vec3 vec) {
        Vec3 vec_flow = this.getFlowVector((IBlockAccess)world, x, y, z);
        double xSpeed = vec_flow.field_72450_a * 0.0845;
        double zSpeed = vec_flow.field_72449_c * 0.0845;
        entity.func_70024_g(xSpeed, 0.0, zSpeed);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta == 0 ? Blocks.field_150355_j.func_149691_a(side, meta) : Blocks.field_150355_j.func_149691_a(side, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        flowing = new IIcon[32];
        still = new IIcon[32];
        for (int i = 0; i < flowing.length; ++i) {
            ItemStack bottle = new ItemStack(Core.bottles, 1, i);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)bottle);
            if (fluid == null || fluid.getFluid() == null || fluid.getFluid().getName() == null) continue;
            String name = fluid.getFluid().getName().replaceAll("\\.", "");
            if (name.contains("molten")) {
                name = "molten" + name.replaceAll("molten", "");
            }
            if (name.contains("fish")) {
                name = "fish" + name.replaceAll("fish", "");
            }
            if (name.contains("natural")) {
                name = "natural" + name.replaceAll("natural", "");
            }
            if (name.contains("normal") || name.contains("water") || name.contains("lava") || name.contains("dirt")) continue;
            BlockPressurisedWater.flowing[i] = iconRegister.func_94245_a("mariculture:liquids/" + name + "_flow");
            BlockPressurisedWater.still[i] = iconRegister.func_94245_a("mariculture:liquids/" + name + "_still");
        }
        xp_still = iconRegister.func_94245_a("mariculture:liquids/xp_flow");
        xp_flow = iconRegister.func_94245_a("mariculture:liquids/xp_still");
    }
}

