/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mariculture.Mariculture;
import mariculture.api.core.MaricultureTab;
import mariculture.api.util.CachedCoords;
import mariculture.core.Core;
import mariculture.core.blocks.base.BlockFunctional;
import mariculture.core.helpers.DirectionHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.PlayerHelper;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.helpers.cofh.ItemHelper;
import mariculture.core.items.ItemHammer;
import mariculture.core.lib.Modules;
import mariculture.core.lib.RenderIds;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.TileAirPump;
import mariculture.core.tile.TileAnvil;
import mariculture.core.tile.TileAutohammer;
import mariculture.core.tile.TileBlockCaster;
import mariculture.core.tile.TileCooling;
import mariculture.core.tile.TileIngotCaster;
import mariculture.core.tile.TileNuggetCaster;
import mariculture.core.util.Fluids;
import mariculture.factory.Factory;
import mariculture.factory.tile.TileFLUDDStand;
import mariculture.factory.tile.TileGenerator;
import mariculture.factory.tile.TileGeyser;
import mariculture.factory.tile.TileRotor;
import mariculture.factory.tile.TileRotorAluminum;
import mariculture.factory.tile.TileRotorCopper;
import mariculture.factory.tile.TileRotorTitanium;
import mariculture.fishery.tile.TileFeeder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockRenderedMachine
extends BlockFunctional {
    public BlockRenderedMachine() {
        super(Material.field_76233_E);
    }

    @Override
    public String getToolType(int meta) {
        return meta == 2 ? null : "pickaxe";
    }

    @Override
    public int getToolLevel(int meta) {
        switch (meta) {
            case 0: 
            case 3: 
            case 5: 
            case 6: {
                return 1;
            }
            case 7: {
                return 2;
            }
        }
        return 0;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 4.0f;
            }
            case 2: {
                return 0.5f;
            }
            case 4: {
                return 1.0f;
            }
            case 3: {
                return 0.85f;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                return 1.5f;
            }
            case 8: {
                return 25.0f;
            }
            case 5: {
                return 5.0f;
            }
            case 6: {
                return 6.5f;
            }
            case 7: {
                return 15.0f;
            }
        }
        return 1.5f;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return RenderIds.RENDER_ALL;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile instanceof TileFLUDDStand) {
                TileFLUDDStand fludd = (TileFLUDDStand)tile;
                fludd.setFacing(ForgeDirection.getOrientation((int)BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity)));
                int water = 0;
                if (stack.func_77942_o()) {
                    water = stack.field_77990_d.func_74762_e("water");
                }
                fludd.tank.setCapacity(20000);
                fludd.tank.setFluidID(Fluids.getFluidID("hp_water"));
                fludd.tank.setFluidAmount(water);
                PacketHandler.updateRender(fludd);
            }
            if (tile instanceof TileGeyser) {
                ((TileGeyser)tile).setFacing(ForgeDirection.getOrientation((int)BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity)));
            }
            if (tile instanceof TileAirPump) {
                ((TileAirPump)tile).setFacing(DirectionHelper.getFacingFromEntity(entity));
            }
            if (tile instanceof TileAnvil) {
                ((TileAnvil)tile).setFacing(DirectionHelper.getFacingFromEntity(entity));
            }
            if (tile instanceof TileRotor) {
                ((TileRotor)tile).setFacing(DirectionHelper.getFacingFromEntity(entity));
            }
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || tile instanceof TileRotor || player.func_70093_af() && !world.field_72995_K) {
            return false;
        }
        if (tile instanceof TileAirPump) {
            TileAirPump pump = (TileAirPump)tile;
            if (!pump.animate) {
                if (Modules.isActive(Modules.diving) && pump.updateAirArea(TileAirPump.Type.CHECK)) {
                    if (!world.field_72995_K) {
                        pump.doPoweredPump(false);
                    }
                    pump.animate = true;
                }
                if (pump.suckUpGas(1024)) {
                    pump.animate = true;
                }
            }
            if (world.field_72995_K && player.func_70093_af()) {
                ((TileAirPump)tile).updateAirArea(TileAirPump.Type.DISPLAY);
            }
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (tile instanceof TileFeeder) {
            player.openGui((Object)Mariculture.instance, -1, world, x, y, z);
            return true;
        }
        if (tile instanceof TileAnvil) {
            if (PlayerHelper.isFake(player)) {
                return false;
            }
            TileAnvil anvil = (TileAnvil)tile;
            if (anvil.func_70301_a(0) != null) {
                if (!world.field_72995_K) {
                    PacketHandler.syncInventory(anvil, anvil.getInventory());
                }
                SpawnItemHelper.addToPlayerInventory(player, world, x, y + 1, z, anvil.func_70301_a(0));
                anvil.func_70299_a(0, null);
            } else if (player.func_71045_bC() != null) {
                ItemStack stack = player.func_71045_bC().func_77946_l();
                stack.field_77994_a = 1;
                anvil.func_70299_a(0, stack);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                }
            }
            return true;
        }
        if (tile instanceof TileAutohammer && side > 1) {
            TileAutohammer hammer = (TileAutohammer)tile;
            int slot = side - 2;
            if (hammer.func_70301_a(slot) != null) {
                if (!world.field_72995_K) {
                    PacketHandler.syncInventory(hammer, hammer.getInventory());
                }
                SpawnItemHelper.addToPlayerInventory(player, world, x, y + 1, z, hammer.func_70301_a(slot));
                hammer.func_70299_a(slot, null);
            } else if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemHammer) {
                ItemStack stack = player.func_71045_bC().func_77946_l();
                hammer.func_70299_a(slot, stack);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                }
            }
            return true;
        }
        if (tile instanceof TileCooling) {
            if (!world.field_72995_K) {
                TileCooling caster = (TileCooling)tile;
                for (int i = 0; i < caster.func_70302_i_(); ++i) {
                    if (caster.func_70301_a(i) == null) continue;
                    SpawnItemHelper.spawnItem(world, x, y + 1, z, caster.func_70301_a(i));
                    caster.func_70299_a(i, null);
                    caster.func_70296_d();
                }
            }
            return FluidHelper.handleFillOrDrain((IFluidHandler)world.func_147438_o(x, y, z), player, ForgeDirection.UP);
        }
        if (tile instanceof TileGeyser) {
            return FluidHelper.handleFillOrDrain((IFluidHandler)world.func_147438_o(x, y, z), player, ForgeDirection.UP);
        }
        return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileAnvil && ItemHelper.isPlayerHoldingItem(Core.hammer, player)) {
            if (player.getDisplayName().equals("[CoFH]")) {
                return;
            }
            if (player instanceof FakePlayer) {
                return;
            }
            ItemStack hammer = player.func_71045_bC();
            if (((TileAnvil)tile).workItem(player, hammer) > 0 && hammer.func_96631_a(1, world.field_73012_v)) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
    }

    public void func_149719_a(IBlockAccess block, int x, int y, int z) {
        int meta = block.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.9f, 0.8f);
                break;
            }
            case 3: {
                TileGeyser geyser = (TileGeyser)block.func_147438_o(x, y, z);
                if (geyser.orientation == ForgeDirection.UP) {
                    this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.25f, 0.9f);
                }
                if (geyser.orientation == ForgeDirection.DOWN) {
                    this.func_149676_a(0.1f, 0.75f, 0.1f, 0.9f, 1.0f, 0.9f);
                }
                if (geyser.orientation == ForgeDirection.EAST) {
                    this.func_149676_a(0.0f, 0.1f, 0.1f, 0.25f, 0.9f, 0.9f);
                }
                if (geyser.orientation == ForgeDirection.WEST) {
                    this.func_149676_a(0.75f, 0.1f, 0.1f, 1.0f, 0.9f, 0.9f);
                }
                if (geyser.orientation == ForgeDirection.SOUTH) {
                    this.func_149676_a(0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.25f);
                }
                if (geyser.orientation != ForgeDirection.NORTH) break;
                this.func_149676_a(0.1f, 0.1f, 0.75f, 0.9f, 0.9f, 1.0f);
                break;
            }
            case 8: {
                TileAnvil anvil = (TileAnvil)block.func_147438_o(x, y, z);
                if (anvil.getFacing() == ForgeDirection.EAST) {
                    this.func_149676_a(0.125f, 0.0f, 0.0f, 0.875f, 1.0f, 1.0f);
                }
                if (anvil.getFacing() == ForgeDirection.NORTH) {
                    this.func_149676_a(0.0f, 0.0f, 0.125f, 1.0f, 1.0f, 0.875f);
                }
                if (anvil.getFacing() == ForgeDirection.WEST) {
                    this.func_149676_a(0.125f, 0.0f, 0.0f, 0.875f, 1.0f, 1.0f);
                }
                if (anvil.getFacing() != ForgeDirection.SOUTH) break;
                this.func_149676_a(0.0f, 0.0f, 0.125f, 1.0f, 1.0f, 0.875f);
                break;
            }
            case 11: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.95f, 1.0f);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 3 || meta == 8 || meta == 11) {
            return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
        }
        return super.func_149668_a(world, x, y, z);
    }

    @Override
    public boolean doesDrop(int meta) {
        if (meta >= 5 && meta <= 7) {
            return false;
        }
        return meta != 4;
    }

    @Override
    public boolean destroyBlock(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileFLUDDStand) {
            TileFLUDDStand stand = (TileFLUDDStand)tile;
            ItemStack fludd = new ItemStack(Factory.fludd);
            fludd.func_77982_d(new NBTTagCompound());
            fludd.field_77990_d.func_74768_a("water", stand.tank.getFluidAmount());
            SpawnItemHelper.spawnItem(world, x, y, z, fludd);
            return world.func_147468_f(x, y, z);
        }
        if (tile instanceof TileRotor) {
            CachedCoords cord = ((TileRotor)tile).master;
            if (cord != null) {
                world.func_147465_d(x, y, z, Core.metals, 5, 2);
                TileEntity gen = world.func_147438_o(cord.x, cord.y, cord.z);
                if (gen instanceof TileGenerator) {
                    ((TileGenerator)tile).reset();
                }
                SpawnItemHelper.spawnItem(world, x, y + 1, z, ((TileRotor)tile).getDrop());
                return true;
            }
            world.func_147465_d(x, y, z, Core.metals, 5, 2);
            SpawnItemHelper.spawnItem(world, x, y + 1, z, ((TileRotor)tile).getDrop());
            return true;
        }
        return super.destroyBlock(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileRotor) {
            ((TileRotor)tile).recheck();
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileRotor) {
            return ((TileRotor)tile).getDrop();
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileAirPump();
            }
            case 2: {
                return new TileFeeder();
            }
            case 4: {
                return new TileFLUDDStand();
            }
            case 3: {
                return new TileGeyser();
            }
            case 9: {
                return new TileIngotCaster();
            }
            case 10: {
                return new TileBlockCaster();
            }
            case 11: {
                return new TileNuggetCaster();
            }
            case 1: {
                return new TileAutohammer();
            }
            case 5: {
                return new TileRotorCopper();
            }
            case 6: {
                return new TileRotorAluminum();
            }
            case 7: {
                return new TileRotorTitanium();
            }
        }
        return new TileAnvil();
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 3) {
            return Blocks.field_150438_bZ.func_149691_a(0, 0);
        }
        if (meta == 9) {
            return super.func_149691_a(side, meta);
        }
        if (meta >= 8) {
            return super.func_149691_a(side, 9);
        }
        if (meta == 5) {
            return Core.metals.func_149691_a(0, 0);
        }
        if (meta == 6) {
            return Core.metals.func_149691_a(0, 1);
        }
        if (meta == 7) {
            return Core.metals.func_149691_a(0, 4);
        }
        return this.icons[meta];
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 2: {
                return Modules.isActive(Modules.fishery);
            }
            case 3: {
                return Modules.isActive(Modules.factory);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValidTab(CreativeTabs tab, int meta) {
        switch (meta) {
            case 2: {
                return tab == MaricultureTab.tabFishery;
            }
        }
        return tab == MaricultureTab.tabFactory;
    }

    @Override
    public int getMetaCount() {
        return 12;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        String name = this.prefix != null ? this.prefix : "";
        this.icons = new IIcon[this.getMetaCount() - 2];
        for (int i = 0; i < this.icons.length; ++i) {
            if (i >= 5 && i != 9 || i == 1) continue;
            this.icons[i] = iconRegister.func_94245_a("mariculture:" + name + this.getName(i));
        }
    }
}

