/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.Mariculture;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.blocks.base.BlockConnected;
import mariculture.core.handlers.FluidDicHandler;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.lib.Modules;
import mariculture.core.lib.RenderIds;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.TileTankBlock;
import mariculture.core.tile.TileVoidBottle;
import mariculture.factory.tile.TileDictionaryFluid;
import mariculture.fishery.tile.TileFishTank;
import mariculture.fishery.tile.TileHatchery;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockTank
extends BlockConnected {
    private static IIcon[] fishTank = new IIcon[47];

    public BlockTank() {
        super(Material.field_76233_E);
    }

    @Override
    public String getToolType(int meta) {
        return meta == 3 ? "axe" : null;
    }

    @Override
    public int getToolLevel(int meta) {
        return meta == 3 ? 1 : 0;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 2: {
                return 0.1f;
            }
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 1.0f;
            }
            case 3: 
            case 4: {
                return 1.5f;
            }
        }
        return 1.0f;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderIds.RENDER_ALL;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileFishTank) {
            if (player.func_70093_af()) {
                return false;
            }
            player.openGui((Object)Mariculture.instance, -1, world, x, y, z);
            return true;
        }
        if (tile instanceof TileDictionaryFluid) {
            if (player.func_70093_af()) {
                return false;
            }
            TileDictionaryFluid dic = (TileDictionaryFluid)tile;
            String next = FluidDicHandler.getNext(dic.getFluid());
            Fluid fluid = FluidRegistry.getFluid((String)next);
            if (fluid != null) {
                dic.tank.setFluid(new FluidStack(fluid, 1));
                PacketHandler.syncFluids(dic, dic.tank.getFluid());
            }
        }
        if (tile instanceof TileHatchery) {
            TileHatchery hatchery = (TileHatchery)tile;
            if (hatchery.func_70301_a(0) != null && player.func_70093_af()) {
                if (!world.field_72995_K) {
                    PacketHandler.syncInventory(hatchery, hatchery.getInventory());
                }
                SpawnItemHelper.addToPlayerInventory(player, world, x, y + 1, z, hatchery.func_70301_a(0));
                hatchery.func_70299_a(0, null);
            } else if (player.func_71045_bC() != null && hatchery.func_70301_a(0) == null) {
                ItemStack stack = player.func_71045_bC().func_77946_l();
                stack.field_77994_a = 1;
                hatchery.func_70299_a(0, stack);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                }
            } else {
                for (int i = 1; i < hatchery.getInventory().length; ++i) {
                    if (hatchery.func_70301_a(i) == null) continue;
                    if (!world.field_72995_K) {
                        PacketHandler.syncInventory(hatchery, hatchery.getInventory());
                    }
                    SpawnItemHelper.addToPlayerInventory(player, world, x, y + 1, z, hatchery.func_70301_a(i));
                    hatchery.func_70299_a(i, null);
                }
            }
            return true;
        }
        return FluidHelper.handleFillOrDrain((IFluidHandler)world.func_147438_o(x, y, z), player, ForgeDirection.UP);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        switch (meta) {
            case 2: {
                return new TileVoidBottle();
            }
            case 0: {
                return new TileTankBlock();
            }
            case 1: {
                return new TileFishTank();
            }
            case 3: {
                return new TileDictionaryFluid();
            }
            case 4: {
                return new TileHatchery();
            }
        }
        return null;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileTankBlock tank;
        FluidStack fluid;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileTankBlock && (fluid = (tank = (TileTankBlock)tile).getFluid()) != null) {
            return fluid.getFluid().getLuminosity();
        }
        return 0;
    }

    @Override
    public int getMetaCount() {
        return 5;
    }

    public void func_149719_a(IBlockAccess block, int x, int y, int z) {
        if (block.func_72805_g(x, y, z) != 2) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.func_149676_a(0.3f, 0.3f, 0.3f, 0.7f, 0.7f, 0.7f);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 2 ? null : super.func_149668_a(world, x, y, z);
    }

    @Override
    public Item func_149650_a(int meta, Random random, int j) {
        switch (meta) {
            case 0: {
                return null;
            }
            case 2: {
                return Core.bottles;
            }
        }
        return super.func_149650_a(meta, random, j);
    }

    @Override
    public int func_149692_a(int meta) {
        switch (meta) {
            case 2: {
                return 0;
            }
        }
        return meta;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int facing = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return;
        }
        if (tile instanceof TileFishTank) {
            ((TileFishTank)tile).orientation = ForgeDirection.getOrientation((int)facing);
        }
        if (stack.func_77942_o() && world.func_72805_g(x, y, z) == 0 && tile instanceof TileTankBlock) {
            TileTankBlock tank = (TileTankBlock)tile;
            tank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.field_77990_d));
            PacketHandler.syncFluids(tank, tank.getFluid());
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 0 && !player.field_71075_bZ.field_75098_d) {
            ItemStack drop = new ItemStack(Core.tanks, 1, 0);
            TileTankBlock tank = (TileTankBlock)world.func_147438_o(x, y, z);
            if (tank != null && tank.getFluid() != null) {
                if (!drop.func_77942_o()) {
                    drop.func_77982_d(new NBTTagCompound());
                }
                tank.getFluid().writeToNBT(drop.field_77990_d);
            }
            SpawnItemHelper.spawnItem(world, x, y, z, drop);
            return world.func_147468_f(x, y, z);
        }
        return world.func_147468_f(x, y, z);
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 2) {
            for (int j = 0; j < 2; ++j) {
                float f = rand.nextFloat() - rand.nextFloat();
                float f1 = rand.nextFloat() - rand.nextFloat();
                float f2 = rand.nextFloat() - rand.nextFloat();
                world.func_72869_a("magicCrit", (double)x + 0.5 + (double)f, (double)y + 0.5 + (double)f1, (double)z + 0.5 + (double)f2, 0.0, 0.0, 0.0);
                world.func_72869_a("witchMagic", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        ItemStack drop = new ItemStack(Core.tanks, 1, meta);
        if (meta == 0) {
            TileTankBlock tank = (TileTankBlock)world.func_147438_o(x, y, z);
            if (tank != null && tank.getFluid() != null) {
                if (!drop.func_77942_o()) {
                    drop.func_77982_d(new NBTTagCompound());
                }
                tank.getFluid().writeToNBT(drop.field_77990_d);
            }
        } else if (meta == 2) {
            drop = new ItemStack(Core.bottles, 1, 0);
        }
        return drop;
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 2: {
                return false;
            }
            case 1: 
            case 4: {
                return Modules.isActive(Modules.fishery);
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValidTab(CreativeTabs tab, int meta) {
        switch (meta) {
            case 1: 
            case 4: {
                return tab == MaricultureTab.tabFishery;
            }
        }
        return tab == MaricultureTab.tabFactory;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int j) {
        BlockHelper.dropFish(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, j);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.getMetaCount()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("mariculture:" + this.getName(i) + "Tank");
        }
        this.registerConnectedTextures(iconRegister);
    }

    @Override
    public IIcon[] getTexture(int meta) {
        return meta == 1 ? fishTank : null;
    }

    @Override
    public void registerConnectedTextures(IIconRegister iconRegister) {
        for (int i = 0; i < 47; ++i) {
            BlockTank.fishTank[i] = iconRegister.func_94245_a("mariculture:fishTank/" + (i + 1));
        }
    }
}

