/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks.base;

import mariculture.Mariculture;
import mariculture.core.blocks.base.BlockDecorative;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.util.IFaceable;
import mariculture.core.util.IHasGUI;
import mariculture.factory.tile.TileCustom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockFunctional
extends BlockDecorative {
    public BlockFunctional(Material material) {
        super(material);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d) {
            return world.func_147468_f(x, y, z);
        }
        if (this.doesDrop(world.func_72805_g(x, y, z))) {
            return super.removedByPlayer(world, player, x, y, z, willHarvest);
        }
        return this.destroyBlock(world, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IFaceable) {
            ((IFaceable)tile).setFacing(ForgeDirection.getOrientation((int)BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity)));
            PacketHandler.updateRender(tile);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof IFaceable) {
            ((IFaceable)tile).rotate();
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || player.func_70093_af() || tile instanceof TileCustom) {
            return false;
        }
        if (tile instanceof TileMultiBlock && tile instanceof IHasGUI) {
            TileMultiBlock multi = (TileMultiBlock)tile;
            if (multi.master != null) {
                player.openGui((Object)Mariculture.instance, -1, world, multi.master.xCoord, multi.master.yCoord, multi.master.zCoord);
                return true;
            }
            return false;
        }
        if (tile instanceof IHasGUI) {
            player.openGui((Object)Mariculture.instance, -1, world, x, y, z);
            return true;
        }
        return true;
    }

    public boolean destroyBlock(World world, int x, int y, int z) {
        return world.func_147468_f(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        BlockHelper.dropItems(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, int var2);
}

