/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import java.util.HashMap;
import mariculture.api.core.ICastingHandler;
import mariculture.api.core.RecipeCasting;
import mariculture.core.helpers.OreDicHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CastingHandler
implements ICastingHandler {
    private final HashMap<String, RecipeCasting> nuggets = new HashMap();
    private final HashMap<String, RecipeCasting> ingots = new HashMap();
    private final HashMap<String, RecipeCasting> blocks = new HashMap();

    @Override
    public void addRecipe(RecipeCasting recipe) {
        if (recipe instanceof RecipeCasting.RecipeNuggetCasting) {
            this.nuggets.put(recipe.fluid.getFluid().getName(), recipe);
        }
        if (recipe instanceof RecipeCasting.RecipeIngotCasting) {
            this.ingots.put(recipe.fluid.getFluid().getName(), recipe);
        }
        if (recipe instanceof RecipeCasting.RecipeBlockCasting) {
            this.blocks.put(recipe.fluid.getFluid().getName(), recipe);
        }
    }

    @Override
    public RecipeCasting getNuggetResult(FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        RecipeCasting result = this.nuggets.get(fluid.getFluid().getName());
        if (result == null) {
            return null;
        }
        return fluid.amount < result.fluid.amount ? null : result;
    }

    @Override
    public RecipeCasting getIngotResult(FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        RecipeCasting result = this.ingots.get(fluid.getFluid().getName());
        if (result == null) {
            return null;
        }
        return fluid.amount < result.fluid.amount ? null : result;
    }

    @Override
    public RecipeCasting getBlockResult(FluidStack fluid) {
        if (fluid == null) {
            return null;
        }
        RecipeCasting result = this.blocks.get(fluid.getFluid().getName());
        if (result == null) {
            return null;
        }
        return fluid.amount < result.fluid.amount ? null : result;
    }

    public static IIcon getTexture(ItemStack stack) {
        String name = OreDicHelper.getDictionaryName(stack);
        name = name.startsWith("nugget") ? name.substring(6) : name.substring(5);
        name = "block" + name;
        Block block = null;
        int damage = stack.func_77960_j();
        if (OreDictionary.getOres((String)name).size() > 0) {
            ItemStack item = (ItemStack)OreDictionary.getOres((String)name).get(0);
            block = Block.func_149634_a((Item)item.func_77973_b());
            damage = item.func_77960_j();
        } else if (stack.func_77973_b() == Items.field_151126_ay) {
            block = Blocks.field_150433_aE;
        } else if (OreDicHelper.getDictionaryName(stack).equals("foodSalt")) {
            block = Blocks.field_150325_L;
            damage = 0;
        } else {
            block = Block.func_149634_a((Item)stack.func_77973_b());
        }
        return block != null ? block.func_149691_a(0, damage) : Blocks.field_150339_S.func_149691_a(0, 0);
    }

    @Override
    public HashMap<String, RecipeCasting> getNuggetRecipes() {
        return this.nuggets;
    }

    @Override
    public HashMap<String, RecipeCasting> getIngotRecipes() {
        return this.ingots;
    }

    @Override
    public HashMap<String, RecipeCasting> getBlockRecipes() {
        return this.blocks;
    }
}

