/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.ICrucibleHandler;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.helpers.ItemHelper;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.util.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CrucibleHandler
implements ICrucibleHandler {
    private static final Random rand = new Random();
    public static Map fuels = new HashMap();
    public static ArrayList<RecipeSmelter> recipes = new ArrayList();

    @Override
    public void addRecipe(RecipeSmelter recipe) {
        recipes.add(recipe);
    }

    @Override
    public RecipeSmelter getResult(ItemStack input, ItemStack input2, int temp) {
        return this.getResult(input, input2, temp, false);
    }

    @Override
    public RecipeSmelter getResult(ItemStack input, ItemStack input2, int temp, boolean ethereal) {
        if ((temp < 0 || temp >= 1500) && ethereal && input != null && input.func_77948_v()) {
            FluidStack stack = Fluids.getBalancedStack("xp");
            stack.amount *= EnchantHelper.getEnchantmentValue(input);
            ItemStack in = input.func_77946_l();
            in.field_77994_a = 1;
            ItemStack ret = input.func_77946_l();
            ret.field_77994_a = 1;
            ret.field_77990_d.func_82580_o("ench");
            return new RecipeSmelter(in, 1500, stack, ret, 1);
        }
        for (RecipeSmelter recipe : recipes) {
            if (temp >= 0 && temp < recipe.temp || !ItemHelper.areEqual(recipe.input, input) || input.field_77994_a < recipe.input.field_77994_a) continue;
            FluidStack fluid = recipe.fluid.copy();
            if (recipe.random != null) {
                for (int i = 0; i < recipe.random.length; ++i) {
                    if (rand.nextInt(recipe.rands[i]) != 0 || (fluid = recipe.random[i]) == null) continue;
                    return new RecipeSmelter(recipe.input, null, recipe.temp, fluid, recipe.output, recipe.chance, new Integer[]{0});
                }
                return new RecipeSmelter(recipe.input, null, recipe.temp, recipe.random[0], recipe.output, recipe.chance, new Integer[]{0});
            }
            if (input.func_77984_f()) {
                double mod = (double)(input.func_77958_k() - input.func_77960_j()) / (double)input.func_77958_k();
                fluid.amount = (int)((double)fluid.amount * mod);
            }
            return recipe;
        }
        return null;
    }

    public String getName(FluidStack fluid) {
        if (fluid.getFluid() == null) {
            return "null";
        }
        return fluid.getFluid().getName();
    }

    @Override
    public void addFuel(Object fuel, FuelInfo info) {
        if (fuel instanceof ItemStack) {
            fuels.put(OreDicHelper.convert(fuel), info);
        }
        if (fuel instanceof FluidStack) {
            fuels.put(this.getName((FluidStack)fuel), info);
        } else if (fuel instanceof String) {
            fuels.put(fuel, info);
        }
    }

    @Override
    public FuelInfo getFuelInfo(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ItemStack) {
            return (FuelInfo)fuels.get(OreDicHelper.convert(obj));
        }
        if (obj instanceof FluidStack) {
            return (FuelInfo)fuels.get(this.getName((FluidStack)obj));
        }
        return null;
    }

    @Override
    public int getMeltingPoint(ItemStack stack) {
        return this.getMeltingPoint(stack, false);
    }

    @Override
    public int getMeltingPoint(ItemStack stack, boolean ethereal) {
        if (ethereal && stack != null && stack.func_77948_v()) {
            return 1500;
        }
        for (RecipeSmelter recipe : recipes) {
            if (!ItemHelper.areEqual(stack, recipe.input)) continue;
            return recipe.temp;
        }
        return -1;
    }

    @Override
    public ArrayList<RecipeSmelter> getRecipes() {
        return recipes;
    }
}

