/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import mariculture.core.config.AutoDictionary;
import mariculture.core.config.GeneralStuff;
import mariculture.core.handlers.LogHandler;
import mariculture.core.helpers.ItemHelper;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.helpers.StackHelper;
import mariculture.plugins.PluginMFR;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class OreDicHandler {
    public static boolean has_unifier = false;
    public static HashMap<String, ArrayList<String>> all;
    public static HashMap<String, ArrayList<String>> entries;
    public static HashMap<String, Integer[]> specials;
    public static HashMap<String, ArrayList<ItemStack>> items;
    public static HashMap<String, String> remappings;

    public static void init() {
        remappings.put("limestone", "blockLimestone");
        remappings.put("glass", "blockGlass");
        OreDicHandler.registerWildcard(new ItemStack(Blocks.field_150344_f), new Integer[]{0, 1, 2, 3, 4, 5});
        OreDicHandler.registerWildcard(new ItemStack((Block)Blocks.field_150376_bx), new Integer[]{0, 1, 2, 3, 4, 5});
        OreDicHandler.registerWildcard(new ItemStack(Blocks.field_150364_r), new Integer[]{0, 1, 2, 3});
        OreDicHandler.registerWildcard(new ItemStack(Blocks.field_150363_s), new Integer[]{0, 1});
        OreDicHandler.registerWildcard(new ItemStack(Blocks.field_150345_g), new Integer[]{0, 1, 2, 3, 4, 5});
        OreDicHandler.registerWildcard(new ItemStack((Block)Blocks.field_150362_t), new Integer[]{0, 1, 2, 3});
        OreDicHandler.registerWildcard(new ItemStack((Block)Blocks.field_150361_u), new Integer[]{0, 1});
    }

    @SubscribeEvent
    public void onOreDictionaryRegistration(OreDictionary.OreRegisterEvent event) {
        if (entries == null) {
            String[] ores;
            all = new HashMap();
            items = new HashMap();
            entries = new HashMap();
            for (String ore : ores = OreDictionary.getOreNames()) {
                ArrayList stacks = OreDictionary.getOres((String)ore);
                for (ItemStack stack : stacks) {
                    if (stack == null || ore == null || ore.equals("")) continue;
                    if (stack.func_77973_b() == null || stack.func_77960_j() == Short.MAX_VALUE) {
                        this.addSpecial(stack, ore);
                        continue;
                    }
                    OreDicHandler.add(stack, ore);
                }
            }
        }
        if (event.Ore != null && !event.Name.equals("")) {
            if (event.Ore.func_77960_j() == Short.MAX_VALUE) {
                this.addSpecial(event.Ore, event.Name);
            } else {
                OreDicHandler.add(event.Ore, event.Name);
            }
        } else if (event.Ore == null) {
            LogHandler.log(Level.ERROR, "A modder has been very silly and attempted to register a null item to the ore dictionary");
            new Exception().printStackTrace();
        } else {
            LogHandler.log(Level.ERROR, "A modder has been very silly and attempted to register an item with a blank name to the ore dictionary!");
            new Exception().printStackTrace();
        }
    }

    public static void syncOreDictionary(ItemStack stack, String string) {
        if (remappings.containsKey(string)) {
            OreDictionary.registerOre((String)remappings.get(string), (ItemStack)stack);
        }
    }

    public static void registerWildcard(ItemStack stack, Integer[] metas) {
        if (stack == null || stack.func_77973_b() == null || metas == null) {
            return;
        }
        String name = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
        specials.put(name, metas);
        if (GeneralStuff.DEBUG_ON) {
            LogHandler.log(Level.INFO, "Successfully registered wildcard for " + name + "(" + stack.toString() + ")");
        }
    }

    private void addSpecial(ItemStack stack, String ore) {
        String name = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
        Integer[] meta = specials.get(name);
        if (meta == null) {
            return;
        }
        for (Integer i : meta) {
            OreDicHandler.add(new ItemStack(stack.func_77973_b(), 1, i.intValue()), ore);
        }
    }

    public static void add(ItemStack stack, String name) {
        String id = ItemHelper.getName(stack);
        ArrayList<Object> alls = all.containsKey(id) ? all.get(id) : new ArrayList();
        alls.add(name);
        all.put(id, alls);
        if (!OreDicHandler.isWhitelisted(name)) {
            if (has_unifier) {
                PluginMFR.blacklist(name);
            }
            return;
        }
        for (String str : AutoDictionary.BLACKLIST_PREFIX_DEFAULT) {
            if (!name.startsWith(str)) continue;
            return;
        }
        for (String str : AutoDictionary.BLACKLIST_ITEMS) {
            ItemStack check = StackHelper.getStackFromString(str);
            if (check == null || check.func_77973_b() != stack.func_77973_b() || check.func_77960_j() != stack.func_77960_j()) continue;
            return;
        }
        ArrayList<Object> list = entries.containsKey(id) ? entries.get(id) : new ArrayList();
        list.add(name);
        entries.put(id, list);
        ArrayList<Object> stacks = items.get(name) != null ? items.get(name) : new ArrayList();
        stacks.add(stack);
        items.put(name, stacks);
        OreDicHandler.syncOreDictionary(stack, name);
    }

    public static boolean isInDictionary(ItemStack stack) {
        return OreDictionary.getOreID((ItemStack)stack) > 0;
    }

    public static boolean areEqual(ItemStack stack1, ItemStack stack2) {
        if (!OreDicHandler.isInDictionary(stack1) || !OreDicHandler.isInDictionary(stack2)) {
            return false;
        }
        ArrayList<String> oreNames1 = entries.get(ItemHelper.getName(stack1));
        ArrayList<String> oreNames2 = entries.get(ItemHelper.getName(stack2));
        if (oreNames1 == null || oreNames2 == null) {
            return false;
        }
        for (String ores1 : oreNames1) {
            for (String ores2 : oreNames2) {
                if (!ores1.equals(ores2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areEqual(ItemStack stack, String item) {
        if (!OreDicHandler.isInDictionary(stack)) {
            return false;
        }
        ArrayList<String> names = entries.get(ItemHelper.getName(stack));
        for (String name : names) {
            if (!name.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWhitelisted(String name) {
        if (AutoDictionary.ENABLE_WHITELIST) {
            for (String whitelist : AutoDictionary.WHITELIST) {
                if (!name.startsWith(whitelist)) continue;
                return true;
            }
            return false;
        }
        for (String blacklist : AutoDictionary.BLACKLIST) {
            if (!name.equals(blacklist)) continue;
            return false;
        }
        for (String start : AutoDictionary.BLACKLIST_PREFIX) {
            if (!name.startsWith(start)) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getNextValidEntry(ItemStack stack) {
        for (String str : AutoDictionary.BLACKLIST_ITEMS) {
            ItemStack check = StackHelper.getStackFromString(str);
            if (check == null || check.func_77973_b() != stack.func_77973_b() || check.func_77960_j() != stack.func_77960_j()) continue;
            return stack;
        }
        NBTTagCompound tag = stack.field_77990_d;
        if (tag != null && tag.func_74764_b("OreDictionaryDisplay")) {
            String old;
            NBTTagCompound display = tag.func_74775_l("OreDictionaryDisplay");
            NBTTagList lore = display.func_150295_c("Lore", 8);
            String string = old = lore.func_150307_f(0) != null ? lore.func_150307_f(0) : "";
            if (!old.equals("")) {
                return OreDicHandler.getNextValidEntry(stack, old);
            }
        }
        return OreDicHandler.getNextValidEntry(stack, OreDicHelper.getDictionaryName(stack));
    }

    private static ItemStack getNextValidEntry(ItemStack stack, String name) {
        String converted = ItemHelper.getName(stack);
        boolean found = false;
        ArrayList<ItemStack> stacks = items.get(name);
        if (stacks == null || stacks.size() < 1) {
            return stack;
        }
        for (ItemStack item : stacks) {
            if (found && item != null && !ItemHelper.getName(item).equals(converted)) {
                ItemStack ret = item.func_77946_l();
                if (!ret.func_77942_o()) {
                    ret.func_77982_d(new NBTTagCompound());
                }
                if (!ret.field_77990_d.func_74764_b("OreDictionaryDisplay")) {
                    ret.field_77990_d.func_74782_a("OreDictionaryDisplay", (NBTBase)new NBTTagCompound());
                }
                ret.field_77990_d.func_74775_l("OreDictionaryDisplay").func_74782_a("Lore", (NBTBase)OreDicHandler.addAllTags(ret, name));
                return ret;
            }
            found = ItemHelper.getName(item).equals(converted);
        }
        ItemStack ret = stacks.get(0).func_77946_l();
        if (!ret.func_77942_o()) {
            ret.func_77982_d(new NBTTagCompound());
        }
        if (!ret.field_77990_d.func_74764_b("OreDictionaryDisplay")) {
            ret.field_77990_d.func_74782_a("OreDictionaryDisplay", (NBTBase)new NBTTagCompound());
        }
        ret.field_77990_d.func_74775_l("OreDictionaryDisplay").func_74782_a("Lore", (NBTBase)OreDicHandler.addAllTags(ret, name));
        return ret;
    }

    public static String getNextString(ItemStack stack, String name) {
        boolean found = false;
        ArrayList<String> names = entries.get(ItemHelper.getName(stack));
        if (names == null) {
            return name;
        }
        for (String entry : names) {
            if (found && !entry.equals(name)) {
                return entry;
            }
            found = entry.equals(name);
        }
        return names.get(0);
    }

    public static NBTTagList addAllTags(ItemStack stack, String name) {
        NBTTagList lore = new NBTTagList();
        lore.func_74742_a((NBTBase)new NBTTagString(name));
        String last = "";
        ArrayList<String> names = entries.get(ItemHelper.getName(stack));
        if (names == null) {
            return lore;
        }
        for (String entry : names) {
            if (entry.equals(name) || last.equals(entry)) continue;
            lore.func_74742_a((NBTBase)new NBTTagString(entry));
            last = entry;
        }
        return lore;
    }

    static {
        specials = new HashMap();
        remappings = new HashMap();
    }
}

