/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import mariculture.api.core.CoralRegistry;
import mariculture.core.config.GeneralStuff;
import mariculture.core.handlers.LogHandler;
import mariculture.core.util.IHasMeta;
import mariculture.core.util.IItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class RegistryHelper {
    public static void registerItems(Item[] items) {
        for (Item item : items) {
            RegistryHelper.registerItem(item);
        }
    }

    public static void registerBlocks(Block[] blocks) {
        for (Block block : blocks) {
            if (block instanceof IHasMeta) {
                RegistryHelper.registerMetaBlock(((IHasMeta)block).getItemClass(), block);
                continue;
            }
            RegistryHelper.registerBlock(block);
        }
    }

    public static void registerTiles(Class<? extends TileEntity>[] tiles) {
        for (Class<? extends TileEntity> tile : tiles) {
            GameRegistry.registerTileEntity(tile, (String)("Mariculture:" + tile.getSimpleName()));
        }
    }

    private static void registerItem(Item item) {
        try {
            String name = item.func_77658_a().substring(5);
            name = name.replace('.', '_');
            if (GeneralStuff.DEBUG_ON) {
                LogHandler.log(Level.DEBUG, "Mariculture successfully registered the item " + item.getClass().getSimpleName() + " as Mariculture:" + name);
            }
            GameRegistry.registerItem((Item)item, (String)name);
            if (item instanceof IItemRegistry) {
                ((IItemRegistry)item).register(item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void registerMetaBlock(Class<? extends ItemBlock> clazz, Block block) {
        try {
            String name = block.func_149739_a().substring(5);
            if (clazz == null) {
                clazz = Class.forName(block.getClass().getCanonicalName().toString() + "Item");
            }
            name = name.replace('.', '_');
            if (GeneralStuff.DEBUG_ON) {
                LogHandler.log(Level.DEBUG, "Mariculture successfully registered the block " + block.getClass().getSimpleName() + " with the item " + clazz.getSimpleName() + " as Mariculture:" + name);
            }
            GameRegistry.registerBlock((Block)block, clazz, (String)name);
            Item item = Item.func_150898_a((Block)block);
            if (item instanceof IItemRegistry) {
                ((IItemRegistry)item).register(item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void registerBlock(Block block) {
        String name = block.func_149739_a().substring(5);
        name = name.replace('.', '_');
        if (GeneralStuff.DEBUG_ON) {
            LogHandler.log(Level.DEBUG, "Mariculture successfully registered the block " + block.getClass().getSimpleName() + " as Mariculture:" + name);
        }
        GameRegistry.registerBlock((Block)block, (String)name);
        Item item = Item.func_150898_a((Block)block);
        if (item instanceof IItemRegistry) {
            ((IItemRegistry)item).register(item);
        }
    }

    public static void registerCoral(ItemStack stack, String color) {
        CoralRegistry.register(stack);
        OreDictionary.registerOre((String)("coral" + color), (ItemStack)stack);
    }

    public static Object getStaticItem(String name, String classPackage) {
        try {
            Class<?> clazz = Class.forName(classPackage);
            Field field = clazz.getDeclaredField(name);
            Object ret = field.get(null);
            if (ret != null && (ret instanceof ItemStack || ret instanceof Item)) {
                return ret;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getName(Object o) {
        if (o instanceof ItemStack) {
            return Item.field_150901_e.func_148750_c((Object)((ItemStack)o).func_77973_b());
        }
        if (o instanceof Item) {
            return Item.field_150901_e.func_148750_c(o);
        }
        if (o instanceof Block) {
            return Block.field_149771_c.func_148750_c(o);
        }
        return null;
    }
}

