/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers.cofh;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class ItemHelper {
    private ItemHelper() {
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack == null) {
            return null;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.field_77994_a = stackSize;
        return retStack;
    }

    public static final boolean isPlayerHoldingItem(Item item, EntityPlayer player) {
        Item equipped;
        Item item2 = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return item == null ? equipped == null : item.equals(equipped);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean areItemStackEqualNoNull(ItemStack stackA, ItemStack stackB) {
        if (!stackA.func_77969_a(stackB)) return false;
        if (stackA.field_77990_d != null) {
            if (stackB.field_77990_d == null) return false;
            if (!stackA.field_77990_d.equals((Object)stackB.field_77990_d)) return false;
            return true;
        }
        if (stackB.field_77990_d == null) return true;
        return false;
    }

    public static boolean areItemStacksEqualNoNBT(ItemStack stackA, ItemStack stackB) {
        if (stackB == null) {
            return false;
        }
        return stackA.func_77973_b() == stackB.func_77973_b() && (stackA.func_77960_j() == Short.MAX_VALUE || stackB.func_77960_j() == Short.MAX_VALUE || !stackA.func_77981_g() || stackB.func_77960_j() == stackA.func_77960_j());
    }

    public static boolean areItemStacksEqualWithNBT(ItemStack stackA, ItemStack stackB) {
        if (stackB == null) {
            return false;
        }
        if (!ItemHelper.doNBTsMatch(stackA.field_77990_d, stackB.field_77990_d)) {
            return false;
        }
        return stackA.func_77973_b() == stackB.func_77973_b() && (stackA.func_77960_j() == Short.MAX_VALUE || stackB.func_77960_j() == Short.MAX_VALUE || !stackA.func_77981_g() || stackB.func_77960_j() == stackA.func_77960_j());
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB, boolean checkNBT) {
        return stackA == null ? stackB == null : stackB != null && stackA.func_77973_b() == stackB.func_77973_b() && stackA.func_77960_j() == stackB.func_77960_j() && (!checkNBT || ItemHelper.doNBTsMatch(stackA.field_77990_d, stackB.field_77990_d));
    }

    public static boolean doNBTsMatch(NBTTagCompound nbtA, NBTTagCompound nbtB) {
        return nbtA == null ? nbtB == null : (nbtB == null ? false : nbtA.equals((Object)nbtB));
    }
}

