/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.items;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mariculture.api.core.MaricultureRegistry;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.helpers.DirectionHelper;
import mariculture.core.helpers.cofh.BlockHelper;
import mariculture.core.tile.TileAnvil;
import mariculture.core.util.IHasGUI;
import mariculture.core.util.IItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemHammer
extends ItemPickaxe
implements IItemRegistry {
    public ItemHammer(Item.ToolMaterial brick) {
        super(brick);
        this.setHarvestLevel("pickaxe", 0);
        this.func_77637_a(MaricultureTab.tabFactory);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        int meta;
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            stack.func_77972_a(1, entity);
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)(meta = world.func_72805_g(x, y, z))) && !this.isAnvil(block, meta)) {
            ForgeDirection dir = DirectionHelper.getFacingFromEntity(entity).getOpposite();
            mariculture.core.helpers.BlockHelper.destroyBlock(world, x, y - 1, z, block, stack);
            for (int i = 1; i <= 2; ++i) {
                mariculture.core.helpers.BlockHelper.destroyBlock(world, x + i * dir.offsetX, y, z + i * dir.offsetZ, block, stack);
                mariculture.core.helpers.BlockHelper.destroyBlock(world, x + i * dir.offsetX, y - 1, z + i * dir.offsetZ, block, stack);
                mariculture.core.helpers.BlockHelper.destroyBlock(world, x - 1 + i * dir.offsetX, y, z + i * dir.offsetZ, block, stack);
                mariculture.core.helpers.BlockHelper.destroyBlock(world, x + 1 + i * dir.offsetX, y - 1, z + i * dir.offsetZ, block, stack);
                mariculture.core.helpers.BlockHelper.destroyBlock(world, x + i * dir.offsetX, y, z - 1 + i * dir.offsetZ, block, stack);
                mariculture.core.helpers.BlockHelper.destroyBlock(world, x + i * dir.offsetX, y - 1, z + 1 + i * dir.offsetZ, block, stack);
            }
        }
        return true;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta) && !this.isAnvil(block, meta)) {
            if (block instanceof BlockStone) {
                return this.field_77864_a * 3.0f;
            }
            return this.field_77864_a;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    private boolean isAnvil(Block block, int meta) {
        return block == Core.renderedMachines && meta == 8;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150324_C) {
            return false;
        }
        if (BlockHelper.canRotate(block)) {
            int meta = world.func_72805_g(x, y, z);
            if (player.func_70093_af()) {
                world.func_72921_c(x, y, z, BlockHelper.rotateVanillaBlockAlt(world, Block.func_149682_b((Block)block), meta, x, y, z), 3);
            } else {
                world.func_72921_c(x, y, z, BlockHelper.rotateVanillaBlock(world, Block.func_149682_b((Block)block), meta, x, y, z), 3);
            }
        }
        if (block != null) {
            if (block == Core.renderedMachines && world.func_72805_g(x, y, z) == 8 && !player.func_70093_af()) {
                return false;
            }
            if (world.func_147438_o(x, y, z) instanceof IHasGUI && !player.func_70093_af()) {
                return false;
            }
            if (block.rotateBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
                return !world.field_72995_K;
            }
        }
        return false;
    }

    public int func_77619_b() {
        return 10;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return !(world.func_147438_o(x, y, z) instanceof TileAnvil);
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == Core.crafting && stack2.func_77960_j() == 14;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 5.0, 0));
        return multimap;
    }

    @Override
    public void register(Item item) {
        MaricultureRegistry.register(this.getName(new ItemStack(item, 1, 0)), new ItemStack(item, 1, 0));
    }

    @Override
    public int getMetaCount() {
        return 1;
    }

    @Override
    public String getName(ItemStack stack) {
        return this.func_77658_a().substring(5);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        String name = this.getName(new ItemStack((Item)this));
        String[] aName = name.split("\\.");
        String theName = aName.length == 2 ? aName[0] + aName[1].substring(0, 1).toUpperCase() + aName[1].substring(1) : name;
        this.field_77791_bV = iconRegister.func_94245_a("mariculture:" + theName);
    }
}

