/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mariculture.core.helpers.ClientHelper;
import mariculture.core.network.PacketCoords;
import mariculture.diving.TileAirCompressor;
import net.minecraft.tileentity.TileEntity;

public class PacketCompressor
extends PacketCoords
implements IMessageHandler<PacketCompressor, IMessage> {
    public int air;
    public int power;

    public PacketCompressor() {
    }

    public PacketCompressor(int x, int y, int z, int air, int power) {
        super(x, y, z);
        this.air = air;
        this.power = power;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.air);
        buffer.writeInt(this.power);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.air = buffer.readInt();
        this.power = buffer.readInt();
    }

    public IMessage onMessage(PacketCompressor message, MessageContext ctx) {
        TileEntity tile = ClientHelper.getPlayer().field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (tile != null && tile instanceof TileAirCompressor) {
            ((TileAirCompressor)tile).storedAir = message.air;
            ((TileAirCompressor)tile).energyStorage.setEnergyStored(message.power);
            ClientHelper.updateRender(message.x, message.y, message.z);
        }
        return null;
    }
}

