/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mariculture.core.helpers.ClientHelper;

public class PacketParticle
implements IMessage,
IMessageHandler<PacketParticle, IMessage> {
    public Particle part;
    public byte loop;
    public double x;
    public double y;
    public double z;

    public PacketParticle() {
    }

    public PacketParticle(Particle part, int loop, double x, double y, double z) {
        this.part = part;
        this.loop = (byte)loop;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.part = Particle.values()[buf.readByte()];
        this.loop = buf.readByte();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.part.ordinal());
        buf.writeByte((int)this.loop);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public IMessage onMessage(PacketParticle message, MessageContext ctx) {
        for (int i = 0; i < message.loop; ++i) {
            ClientHelper.getPlayer().field_70170_p.func_72869_a(message.part.getParticle(), message.x + 0.5, message.y + 0.85, message.z + 0.5, 0.0, 0.0, 0.0);
        }
        return null;
    }

    public static enum Particle {
        SPLASH("splash"),
        EXPLODE_SML("explode"),
        EXPLODE_LRG("hugeexplosion");

        public final String string;

        private Particle(String string2) {
            this.string = string2;
        }

        public String getParticle() {
            return this.string;
        }
    }
}

