/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mariculture.core.helpers.ClientHelper;
import mariculture.core.network.PacketCoords;
import mariculture.core.network.PacketHandler;
import mariculture.factory.tile.TileSponge;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketSponge
extends PacketCoords
implements IMessageHandler<PacketSponge, IMessage> {
    private int stored;
    private int max;
    private boolean isClient;

    public PacketSponge() {
    }

    public PacketSponge(int x, int y, int z, boolean isClient) {
        super(x, y, z);
        this.isClient = isClient;
    }

    private PacketSponge(int stored, int max, boolean isClient) {
        this.stored = stored;
        this.max = max;
        this.isClient = isClient;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.isClient);
        if (this.isClient) {
            super.toBytes(buffer);
        } else {
            buffer.writeInt(this.stored);
            buffer.writeInt(this.max);
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.isClient = buffer.readBoolean();
        if (this.isClient) {
            super.fromBytes(buffer);
        } else {
            this.stored = buffer.readInt();
            this.max = buffer.readInt();
        }
    }

    public IMessage onMessage(PacketSponge message, MessageContext ctx) {
        if (!message.isClient) {
            ClientHelper.addToChat(message.stored + " / " + message.max + " RF");
        } else {
            TileEntity tile = ctx.getServerHandler().field_147369_b.field_70170_p.func_147438_o(message.x, message.y, message.z);
            if (tile != null && tile instanceof TileSponge) {
                TileSponge sponge = (TileSponge)tile;
                this.stored = sponge.getEnergyStored(ForgeDirection.UNKNOWN);
                this.max = sponge.getMaxEnergyStored(ForgeDirection.UNKNOWN);
                PacketHandler.sendToClient(new PacketSponge(this.stored, this.max, false), ctx.getServerHandler().field_147369_b);
            }
        }
        return null;
    }
}

