/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mariculture.api.core.IAnvilHandler;
import mariculture.core.Core;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.NBTHelper;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.items.ItemWorked;
import mariculture.core.lib.Modules;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.base.TileStorage;
import mariculture.core.util.IFaceable;
import mariculture.magic.JewelryHandler;
import mariculture.magic.jewelry.ItemJewelry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAnvil
extends TileStorage
implements ISidedInventory,
IAnvilHandler,
IFaceable {
    private static final HashMap<String, IAnvilHandler.RecipeAnvil> recipes = new HashMap();
    public ForgeDirection orientation = ForgeDirection.EAST;

    public TileAnvil() {
        this.inventory = new ItemStack[1];
    }

    @Override
    public void addRecipe(IAnvilHandler.RecipeAnvil recipe) {
        recipes.put(OreDicHelper.convert(recipe.input), recipe);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.syncInventory(this, this.inventory);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean canBeWorked(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemWorked) {
            return true;
        }
        IAnvilHandler.RecipeAnvil result = recipes.get(OreDicHelper.convert(stack));
        return result != null;
    }

    public boolean canBeRepaired(ItemStack stack) {
        return stack.func_77984_f() && stack.func_77951_h() && stack.func_77973_b().isRepairable() ? stack.func_77960_j() > 0 : stack.func_77973_b() instanceof ItemJewelry && stack.func_77960_j() > 0;
    }

    private boolean hasXP(EntityPlayer player, float xp) {
        return player.field_71106_cc >= xp * 0.05882353f || player.field_71068_ca > 0;
    }

    public int workItem(EntityPlayer player, ItemStack hammer) {
        if (hammer == null) {
            return 0;
        }
        ItemStack stack = this.func_70301_a(0);
        if (stack == null) {
            return 0;
        }
        if (!this.canBeWorked(stack)) {
            int modifier = 1;
            if (stack.func_77948_v()) {
                LinkedHashMap maps = (LinkedHashMap)EnchantmentHelper.func_82781_a((ItemStack)stack);
                for (Map.Entry i : maps.entrySet()) {
                    int total = (Integer)maps.entrySet().iterator().next().getValue();
                    Enchantment enchant = Enchantment.field_77331_b[(Integer)maps.keySet().iterator().next()];
                    int bonus = enchant.func_77317_b(1) - enchant.func_77321_a(1);
                    modifier += total + bonus;
                }
                int n = modifier = (modifier /= 3) >= 1 ? modifier : 1;
                if (stack.func_77973_b() instanceof ItemJewelry) {
                    modifier = (int)((float)modifier * JewelryHandler.getMaterial(stack).getRepairModifier(JewelryHandler.getType(stack)));
                }
            }
            float effiency = 1.0f - (float)(EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)hammer) / 25);
            float drop = 1.0f / (float)(player.func_71050_bK() * 1) / 4.0f * (float)modifier * effiency;
            if (this.hasXP(player, drop) && this.canBeRepaired(stack)) {
                int ret;
                float experience;
                for (int i = 0; i < EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)hammer); ++i) {
                    if (this.field_145850_b.field_73012_v.nextInt(3) != 0) continue;
                    stack.func_77964_b(stack.func_77960_j() - 1);
                }
                stack.func_77964_b(stack.func_77960_j() - 1);
                if (stack.func_77960_j() < 0) {
                    stack.func_77964_b(0);
                }
                if ((experience = player.field_71106_cc - drop) <= 0.0f) {
                    player.field_71106_cc = 1.0f;
                    --player.field_71068_ca;
                } else {
                    player.field_71106_cc = experience;
                }
                if (stack.func_77960_j() == 0) {
                    this.field_145850_b.func_72869_a("hugeexplosion", (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
                } else {
                    this.field_145850_b.func_72869_a("explode", (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
                }
                if (this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72956_a((Entity)player, "mariculture:hammer", 1.0f, 1.0f);
                }
                if (stack.func_77960_j() != 0) {
                    ret = (int)(drop / 0.05882353f * 1.0f);
                    return Math.max(1, ret);
                }
                ret = (int)(drop / 0.05882353f * 1.0f);
                return Math.max(1, ret) + 5000;
            }
            return 0;
        }
        if (!(stack.func_77973_b() instanceof ItemWorked) && this.hasXP(player, 1.0f)) {
            IAnvilHandler.RecipeAnvil recipe = recipes.get(OreDicHelper.convert(stack));
            this.func_70299_a(0, this.createWorkedItem(recipe.output.func_77946_l(), recipe.hits));
            this.field_145850_b.func_72956_a((Entity)player, "mariculture:hammer", 1.0f, 1.0f);
            return 1;
        }
        if (this.hasXP(player, 2.0f)) {
            int workedVal = stack.field_77990_d.func_74762_e("Worked") + 1;
            stack.field_77990_d.func_74768_a("Worked", workedVal);
            if (workedVal >= stack.field_77990_d.func_74762_e("Required")) {
                ItemStack result = NBTHelper.getItemStackFromNBT(stack.field_77990_d.func_74775_l("WorkedItem"));
                if (Modules.isActive(Modules.magic)) {
                    result = JewelryHandler.finishJewelry(stack, result, this.field_145850_b.field_73012_v);
                }
                this.func_70299_a(0, result);
                this.field_145850_b.func_72869_a("hugeexplosion", (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
                this.field_145850_b.func_72956_a((Entity)player, "mariculture:bang", 1.0f, 1.0f);
                return 5000;
            }
            this.field_145850_b.func_72869_a("explode", (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
            this.field_145850_b.func_72956_a((Entity)player, "mariculture:hammer", 1.0f, 1.0f);
            return -1;
        }
        return 0;
    }

    @Override
    public ItemStack createWorkedItem(ItemStack output, int hits) {
        ItemStack worked = new ItemStack(Core.worked);
        worked.func_77982_d(new NBTTagCompound());
        worked.field_77990_d.func_74768_a("Worked", 0);
        worked.field_77990_d.func_74768_a("Required", hits);
        worked.field_77990_d.func_74782_a("WorkedItem", (NBTBase)NBTHelper.writeItemStackToNBT(new NBTTagCompound(), output));
        return worked;
    }

    @Override
    public boolean rotate() {
        this.setFacing(BlockHelper.rotate(this.orientation, 4));
        return true;
    }

    @Override
    public ForgeDirection getFacing() {
        return this.orientation;
    }

    @Override
    public void setFacing(ForgeDirection dir) {
        this.orientation = dir;
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.updateOrientation(this);
        }
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return side == ForgeDirection.UP.ordinal() && this.inventory[0] == null;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (stack.func_77973_b() instanceof ItemWorked) {
            return side == ForgeDirection.UP.ordinal();
        }
        return true;
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public HashMap<String, IAnvilHandler.RecipeAnvil> getRecipes() {
        return recipes;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.orientation = ForgeDirection.getOrientation((int)nbt.func_74762_e("Orientation"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Orientation", this.orientation.ordinal());
    }
}

