/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile.base;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import java.util.Arrays;
import mariculture.core.tile.base.TileMachine;
import mariculture.core.util.IPowered;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileMachinePowered
extends TileMachine
implements IEnergyHandler,
IPowered {
    protected EnergyStorage energyStorage = new EnergyStorage(this.getRFCapacity());
    protected int usage = -1;

    public TileMachinePowered() {
        this.inventory = new ItemStack[4];
        this.offset = 4;
    }

    public abstract int getRFCapacity();

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.usage == -1) {
                this.updatePowerPerTick();
            }
            int ret = this.energyStorage.receiveEnergy(maxReceive, simulate);
            if (!this.canWork && this.energyStorage.getEnergyStored() >= this.getPowerPerTick() * 2) {
                this.updateCanWork();
            }
            return ret;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        int ret = this.energyStorage.extractEnergy(maxExtract, simulate);
        if (ret <= 0) {
            this.updateCanWork();
        }
        return ret;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public int getPowerPerTick() {
        return this.usage;
    }

    @Override
    public void updatePowerPerTick() {
        this.usage = (int)(1.05 - (double)(this.rf / 300000) * 0.75);
    }

    @Override
    public boolean isConsumer() {
        return true;
    }

    @Override
    public void updateUpgrades() {
        super.updateUpgrades();
        this.energyStorage.setCapacity(this.getRFCapacity() + this.rf);
        this.updatePowerPerTick();
    }

    @Override
    public void updateMachine() {
        if (this.canWork) {
            this.extractEnergy(ForgeDirection.DOWN, this.getPowerPerTick(), false);
            this.processed += this.speed;
            if (this.processed >= this.max) {
                this.process();
                this.updateCanWork();
                this.processed = 0;
            }
        } else {
            this.processed = 0;
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.inventory[3] != null) {
            int drain;
            int rf;
            int n = rf = this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IEnergyContainerItem ? ((IEnergyContainerItem)this.inventory[3].func_77973_b()).extractEnergy(this.inventory[3], 1000, true) : 0;
            if (rf > 0 && (drain = this.receiveEnergy(ForgeDirection.UP, rf, true)) > 0) {
                ((IEnergyContainerItem)this.inventory[3].func_77973_b()).extractEnergy(this.inventory[3], drain, false);
                if (this.inventory[3] == null || this.inventory[3].field_77994_a <= 0) {
                    this.func_70298_a(3, 1);
                }
                this.receiveEnergy(ForgeDirection.UP, drain, false);
            }
        }
    }

    @Override
    public void setGUIData(int id, int value) {
        super.setGUIData(id, value);
        switch (id) {
            case 3: {
                this.energyStorage.setEnergyStored(value);
                break;
            }
            case 4: {
                this.energyStorage.setCapacity(value);
                break;
            }
            case 5: {
                this.usage = value;
            }
        }
    }

    @Override
    public ArrayList<Integer> getGUIData() {
        ArrayList<Integer> list = super.getGUIData();
        list.addAll(new ArrayList<Integer>(Arrays.asList(this.energyStorage.getEnergyStored(), this.energyStorage.getMaxEnergyStored(), this.canWork ? this.getPowerPerTick() : 0)));
        return list;
    }

    @Override
    public String getPowerText() {
        return this.getEnergyStored(ForgeDirection.UNKNOWN) + " / " + this.getMaxEnergyStored(ForgeDirection.UNKNOWN) + " RF";
    }

    @Override
    public int getPowerScaled(int i) {
        return this.energyStorage.getEnergyStored() * i / this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energyStorage.writeToNBT(nbt);
    }
}

