/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile.base;

import java.util.ArrayList;
import mariculture.core.network.PacketHandler;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMultiBlock
extends TileEntity {
    protected boolean needsInit = false;
    protected boolean init = false;
    public ForgeDirection facing = ForgeDirection.UNKNOWN;
    public ArrayList<MultiPart> slaves = new ArrayList();
    public MultiPart master;

    protected MultiPart setAsSlave(MultiPart master, int x, int y, int z) {
        TileMultiBlock slave = (TileMultiBlock)this.field_145850_b.func_147438_o(x, y, z);
        slave.setMaster(new MultiPart(master.xCoord, master.yCoord, master.zCoord));
        return new MultiPart(x, y, z);
    }

    protected void setAsMaster(MultiPart mstr, ArrayList<MultiPart> parts) {
        TileMultiBlock master = (TileMultiBlock)this.field_145850_b.func_147438_o(mstr.xCoord, mstr.yCoord, mstr.zCoord);
        master.setMaster(mstr);
        master.setSlaves(parts);
    }

    protected MultiPart setAsSlave(MultiPart master, int x, int y, int z, ForgeDirection dir) {
        ((TileMultiBlock)this.field_145850_b.func_147438_o(x, y, z)).setFacing(dir);
        return this.setAsSlave(master, x, y, z);
    }

    protected void setAsMaster(MultiPart mstr, ArrayList<MultiPart> parts, ForgeDirection dir) {
        ((TileMultiBlock)this.field_145850_b.func_147438_o(mstr.xCoord, mstr.yCoord, mstr.zCoord)).setFacing(dir);
        this.setAsMaster(mstr, parts);
    }

    public void setMaster(MultiPart mstr) {
        this.master = mstr;
    }

    public void setSlaves(ArrayList<MultiPart> parts) {
        this.slaves = parts;
    }

    public boolean isPart(int x, int y, int z) {
        return this.field_145850_b.func_147438_o(x, y, z) instanceof TileMultiBlock;
    }

    public boolean isMaster() {
        return this.master != null && this.master.isSame(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected boolean isInit() {
        return this.init;
    }

    public TileMultiBlock getMaster() {
        if (this.master == null) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord);
        return tile != null && tile instanceof TileMultiBlock ? (TileMultiBlock)tile : null;
    }

    public ArrayList<MultiPart> getSlaves() {
        return this.slaves;
    }

    protected void addSlave(MultiPart slave) {
        this.slaves.add(slave);
    }

    public void removeSlave(MultiPart part) {
        this.slaves.remove(part);
    }

    public void setFacing(ForgeDirection dir) {
        this.facing = dir;
    }

    public void setInit(boolean bool) {
        this.init = bool;
    }

    public boolean isPartnered(int x, int y, int z) {
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        return tile instanceof TileMultiBlock ? ((TileMultiBlock)tile).master != null : false;
    }

    public void onBlockPlaced() {
        ArrayList<MultiPart> parts;
        MultiPart mstr;
        if (this.isPart(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !this.isPart(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) && !this.isPart(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e)) {
            mstr = new MultiPart(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            parts = new ArrayList<MultiPart>();
            parts.add(this.setAsSlave(mstr, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e));
            this.setAsMaster(mstr, parts);
        }
        if (this.isPart(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) && !this.isPart(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !this.isPart(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e)) {
            mstr = new MultiPart(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.setAsMaster(mstr, parts);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onBlockBreak() {
        TileMultiBlock mstr;
        if (this.master != null && (mstr = (TileMultiBlock)this.field_145850_b.func_147438_o(this.master.xCoord, this.master.yCoord, this.master.zCoord)) != null) {
            if (mstr.slaves != null) {
                for (MultiPart part : mstr.slaves) {
                    if (this.field_145850_b.func_147438_o(part.xCoord, part.yCoord, part.zCoord) == null) continue;
                    TileMultiBlock te = (TileMultiBlock)this.field_145850_b.func_147438_o(part.xCoord, part.yCoord, part.zCoord);
                    te.setMaster(null);
                    te.setInit(false);
                    te.setFacing(ForgeDirection.UNKNOWN);
                    PacketHandler.breakMultiBlock(te);
                }
            }
            mstr.setSlaves(null);
            mstr.setMaster(null);
            mstr.setInit(false);
            mstr.setFacing(ForgeDirection.UNKNOWN);
            PacketHandler.breakMultiBlock(mstr);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_145845_h() {
        if (this.master != null) {
            if (this.isMaster()) {
                if (!this.field_145850_b.field_72995_K && this.needsInit && !this.init) {
                    this.init();
                }
                this.updateMaster();
            } else {
                this.updateSlaves();
            }
        }
    }

    public void init() {
        TileMultiBlock master = this.getMaster();
        PacketHandler.syncMultiBlock(master, this, this.facing);
        for (MultiPart slave : this.slaves) {
            TileEntity te = this.field_145850_b.func_147438_o(slave.xCoord, slave.yCoord, slave.zCoord);
            if (te == null || !te.getClass().equals(this.getTEClass())) continue;
            PacketHandler.syncMultiBlock(master, te, ((TileMultiBlock)te).facing);
        }
        this.setInit(true);
    }

    public Class getTEClass() {
        return ((Object)((Object)this)).getClass();
    }

    public void updateMaster() {
    }

    public void updateSlaves() {
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        boolean built = nbt.func_74767_n("Built");
        if (built) {
            this.facing = ForgeDirection.values()[nbt.func_74762_e("Facing")];
            int mstrX = nbt.func_74762_e("MasterX");
            int mstrY = nbt.func_74762_e("MasterY");
            int mstrZ = nbt.func_74762_e("MasterZ");
            this.master = new MultiPart(mstrX, mstrY, mstrZ);
            if (this.master.isSame(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.slaves = new ArrayList();
                NBTTagList tagList = nbt.func_150295_c("Slaves", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    int x = tag.func_74762_e("xCoord");
                    int y = tag.func_74762_e("yCoord");
                    int z = tag.func_74762_e("zCoord");
                    this.slaves.add(new MultiPart(x, y, z));
                }
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.master != null) {
            nbt.func_74768_a("MasterX", this.master.xCoord);
            nbt.func_74768_a("MasterY", this.master.yCoord);
            nbt.func_74768_a("MasterZ", this.master.zCoord);
            nbt.func_74757_a("Built", true);
            nbt.func_74768_a("Facing", this.facing.ordinal());
            NBTTagList itemList = new NBTTagList();
            if (this.slaves != null) {
                for (MultiPart part : this.slaves) {
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74768_a("xCoord", part.xCoord);
                    tag.func_74768_a("yCoord", part.yCoord);
                    tag.func_74768_a("zCoord", part.zCoord);
                    itemList.func_74742_a((NBTBase)tag);
                }
            }
            nbt.func_74782_a("Slaves", (NBTBase)itemList);
        } else {
            nbt.func_74757_a("Built", false);
            nbt.func_74768_a("Facing", ForgeDirection.UNKNOWN.ordinal());
        }
    }

    public static class MultiPart {
        public int xCoord;
        public int yCoord;
        public int zCoord;

        public MultiPart(int x, int y, int z) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
        }

        public boolean isSame(int x, int y, int z) {
            return x == this.xCoord && y == this.yCoord && z == this.zCoord;
        }
    }
}

