/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.tile.base;

import java.util.ArrayList;
import java.util.Arrays;
import mariculture.api.core.IUpgradable;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.BlockTransferHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.tile.base.TileMultiBlock;
import mariculture.core.tile.base.TileMultiStorageTank;
import mariculture.core.util.IEjectable;
import mariculture.core.util.IMachine;
import mariculture.core.util.IProgressable;
import mariculture.core.util.IRedstoneControlled;
import mariculture.core.util.Tank;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileMultiMachineTank
extends TileMultiStorageTank
implements IUpgradable,
IMachine,
ISidedInventory,
IRedstoneControlled,
IEjectable,
IProgressable {
    protected BlockTransferHelper helper;
    private int machineTick = 0;
    protected int purity = 0;
    protected int heat = 0;
    protected int storage = 0;
    public int speed = 0;
    protected int rf = 0;
    public FeatureEject.EjectSetting setting;
    public FeatureRedstone.RedstoneMode mode;
    protected int offset = 9;
    protected int max;
    protected boolean canWork;
    protected int processed = 0;

    public TileMultiMachineTank() {
        this.inventory = new ItemStack[5];
        this.tank = new Tank(this.getTankCapacity(this.storage));
        this.mode = FeatureRedstone.RedstoneMode.LOW;
        this.setting = FeatureEject.EjectSetting.NONE;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.getMasterInventory();
    }

    public boolean onTick(int i) {
        return this.machineTick % i == 0;
    }

    @Override
    public ItemStack[] getUpgrades() {
        return new ItemStack[]{this.inventory[0], this.inventory[1], this.inventory[2]};
    }

    public int[] getInputSlots() {
        return null;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        int[] inputs;
        TileMultiMachineTank mstr;
        TileMultiMachineTank tileMultiMachineTank = mstr = this.getMaster() != null ? (TileMultiMachineTank)this.getMaster() : null;
        if (mstr == null) {
            return;
        }
        mstr.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > mstr.func_70297_j_()) {
            stack.field_77994_a = mstr.func_70297_j_();
        }
        if ((inputs = this.getInputSlots()) != null) {
            for (int i : inputs) {
                if (slot != i) continue;
                mstr.canWork = mstr.canWork();
            }
        }
        mstr.func_70296_d();
    }

    @Override
    public void updateUpgrades() {
        this.purity = MaricultureHandlers.upgrades.getData("purity", this);
        this.heat = MaricultureHandlers.upgrades.getData("temp", this);
        this.storage = MaricultureHandlers.upgrades.getData("storage", this);
        this.speed = MaricultureHandlers.upgrades.getData("speed", this);
        this.rf = MaricultureHandlers.upgrades.getData("rf", this);
        this.tank.setCapacity(this.getTankCapacity(this.storage));
        if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
            this.tank.setFluidAmount(this.tank.getCapacity());
        }
    }

    public int getTankCapacity(int storage) {
        int tankRate = 1000;
        return tankRate * 25 + storage * tankRate * 5;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateMaster() {
        super.updateMaster();
        if (this.helper == null) {
            this.helper = new BlockTransferHelper(this);
        }
        ++this.machineTick;
        if (this.onTick(20)) {
            FluidHelper.process(this, 3, 4);
            this.updateUpgrades();
        }
        if (this.onTick(20)) {
            this.canWork = this.canWork();
        }
        this.updateMasterMachine();
    }

    @Override
    public void updateSlaves() {
        if (this.helper == null) {
            this.helper = new BlockTransferHelper(this);
        }
        ++this.machineTick;
        this.updateSlaveMachine();
    }

    public abstract boolean canWork();

    public abstract void updateMasterMachine();

    public abstract void updateSlaveMachine();

    public boolean rsAllowsWork() {
        if (this.getMaster() != null) {
            TileMultiMachineTank mstr = (TileMultiMachineTank)this.getMaster();
            FeatureRedstone.RedstoneMode mode = mstr.mode;
            if (mode == FeatureRedstone.RedstoneMode.DISABLED) {
                return true;
            }
            for (TileMultiBlock.MultiPart block : mstr.slaves) {
                if (mode.equals((Object)FeatureRedstone.RedstoneMode.LOW)) {
                    if (FeatureRedstone.RedstoneMode.canWork(this.field_145850_b.func_147438_o(block.xCoord, block.yCoord, block.zCoord), mode)) continue;
                    return false;
                }
                if (!mode.equals((Object)FeatureRedstone.RedstoneMode.HIGH) || !FeatureRedstone.RedstoneMode.canWork(this.field_145850_b.func_147438_o(block.xCoord, block.yCoord, block.zCoord), mode)) continue;
                return true;
            }
            return FeatureRedstone.RedstoneMode.canWork(this.getMaster(), mode);
        }
        return false;
    }

    @Override
    public void setGUIData(int id, int value) {
        if (this.master == null) {
            this.master = new TileMultiBlock.MultiPart(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        switch (id) {
            case 0: {
                this.mode = FeatureRedstone.RedstoneMode.values()[value];
                break;
            }
            case 1: {
                this.setting = FeatureEject.EjectSetting.values()[value];
                break;
            }
            case 2: {
                this.processed = value;
                break;
            }
            case 3: {
                this.tank.setFluidID(value);
                break;
            }
            case 4: {
                this.tank.setFluidAmount(value);
                break;
            }
            case 5: {
                this.tank.setCapacity(value);
                break;
            }
            case 6: {
                if (this.master == null) break;
                this.master.xCoord = value;
                break;
            }
            case 7: {
                if (this.master == null) break;
                this.master.yCoord = value;
                break;
            }
            case 8: {
                if (this.master == null) break;
                this.master.zCoord = value;
            }
        }
    }

    @Override
    public ArrayList<Integer> getGUIData() {
        return new ArrayList<Integer>(Arrays.asList(this.mode.ordinal(), this.setting.ordinal(), this.processed, this.tank.getFluidID(), this.tank.getFluidAmount(), this.tank.getCapacity(), this.master != null ? this.master.xCoord : 0, this.master != null ? this.master.yCoord : 0, this.master != null ? this.master.zCoord : 0));
    }

    @Override
    public void handleButtonClick(int id) {
        if (id == -777) {
            this.setRSMode(FeatureRedstone.RedstoneMode.toggle(this.getRSMode()));
        }
        if (id == -888) {
            this.setEjectSetting(FeatureEject.EjectSetting.toggle(this.getEjectType(), this.getEjectSetting()));
        }
    }

    @Override
    public FeatureRedstone.RedstoneMode getRSMode() {
        return this.mode != null ? this.mode : FeatureRedstone.RedstoneMode.DISABLED;
    }

    @Override
    public void setRSMode(FeatureRedstone.RedstoneMode mode) {
        this.mode = mode;
    }

    @Override
    public FeatureEject.EjectSetting getEjectSetting() {
        return this.setting != null ? this.setting : FeatureEject.EjectSetting.NONE;
    }

    @Override
    public void setEjectSetting(FeatureEject.EjectSetting setting) {
        this.setting = setting;
    }

    @Override
    public int getProgressScaled(int scale) {
        return this.processed * scale / this.max;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setting = FeatureEject.EjectSetting.readFromNBT(nbt);
        this.mode = FeatureRedstone.RedstoneMode.readFromNBT(nbt);
        this.purity = nbt.func_74762_e("Purity");
        this.heat = nbt.func_74762_e("Heat");
        this.storage = nbt.func_74762_e("Storage");
        this.speed = nbt.func_74762_e("Speed");
        this.rf = nbt.func_74762_e("RF");
        this.canWork = nbt.func_74767_n("CanWork");
        this.processed = nbt.func_74762_e("Processed");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        FeatureEject.EjectSetting.writeToNBT(nbt, this.setting);
        FeatureRedstone.RedstoneMode.writeToNBT(nbt, this.mode);
        nbt.func_74768_a("Purity", this.purity);
        nbt.func_74768_a("Heat", this.heat);
        nbt.func_74768_a("Storage", this.storage);
        nbt.func_74768_a("Speed", this.speed);
        nbt.func_74768_a("RF", this.rf);
        nbt.func_74757_a("CanWork", this.canWork);
        nbt.func_74768_a("Processed", this.processed);
    }
}

