/*
 * Decompiled with CFR 0.152.
 */
package mariculture.diving;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import mariculture.core.Core;
import mariculture.core.config.GeneralStuff;
import mariculture.core.helpers.PlayerHelper;
import mariculture.core.lib.ArmorSlot;
import mariculture.diving.Diving;
import mariculture.diving.DivingBoots;
import mariculture.diving.HardcoreDiving;
import mariculture.diving.LifeJacket;
import mariculture.diving.ScubaFin;
import mariculture.diving.ScubaMask;
import mariculture.diving.ScubaTank;
import mariculture.diving.Snorkel;
import mariculture.diving.UnderwaterVision;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class DivingEventHandler {
    private int tick;
    private static UnderwaterVision vision;

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ++this.tick;
            if (!player.field_70170_p.field_72995_K) {
                Snorkel.init(player);
                if (this.tick % 5 == 0) {
                    ScubaTank.init(player);
                    ScubaMask.damage(player);
                    if (GeneralStuff.HARDCORE_DIVING > 0) {
                        HardcoreDiving.init(player);
                    }
                }
            } else {
                vision = vision == null ? new UnderwaterVision() : vision.onUpdate(player);
                DivingBoots.init(player);
                LifeJacket.init(player);
                ScubaFin.init(player);
            }
        }
    }

    @SubscribeEvent
    public void onBreaking(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.entityPlayer;
        boolean isValid = false;
        if (ForgeHooks.canHarvestBlock((Block)event.block, (EntityPlayer)player, (int)event.metadata) && player.func_70055_a(Material.field_151586_h)) {
            if (PlayerHelper.hasArmor(player, ArmorSlot.LEG, Diving.scubaSuit)) {
                event.newSpeed = event.originalSpeed * 4.0f;
                if (event.block == Core.water && event.metadata == 0) {
                    event.newSpeed = event.originalSpeed * 128.0f;
                }
            }
            if (PlayerHelper.hasArmor(player, ArmorSlot.FEET, Diving.swimfin) && !player.field_70122_E) {
                event.newSpeed *= 5.0f;
            }
            if (PlayerHelper.hasArmor(player, ArmorSlot.LEG, Diving.divingPants)) {
                event.newSpeed = event.originalSpeed * 2.0f;
                if (event.block == Core.water && event.metadata == 0) {
                    event.newSpeed = event.originalSpeed * 64.0f;
                }
            }
        }
    }

    private boolean isAllowed(ItemStack stack, ItemStack stack2) {
        if (stack != null && stack.func_77973_b() == Diving.snorkel) {
            return stack2 == null || stack2.func_77973_b() != Items.field_151134_bR;
        }
        return true;
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        if (!this.isAllowed(event.left, event.right) || !this.isAllowed(event.right, event.left)) {
            event.setCanceled(true);
        }
    }
}

