/*
 * Decompiled with CFR 0.152.
 */
package mariculture.diving;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import mariculture.core.network.PacketCompressor;
import mariculture.core.network.PacketHandler;
import mariculture.core.tile.base.TileMultiBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAirCompressor
extends TileMultiBlock
implements IEnergyHandler {
    private int machineTick;
    public static final int max = 480;
    public int storedAir = 0;
    public EnergyStorage energyStorage = new EnergyStorage(10000);

    public TileAirCompressor() {
        this.needsInit = true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.getMaster() != null ? ((TileAirCompressor)this.getMaster()).energyStorage.receiveEnergy(maxReceive, simulate) : 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.getMaster() != null ? ((TileAirCompressor)this.getMaster()).energyStorage.extractEnergy(maxExtract, simulate) : 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getMaster() != null ? ((TileAirCompressor)this.getMaster()).energyStorage.getEnergyStored() : 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaster() != null ? ((TileAirCompressor)this.getMaster()).energyStorage.getMaxEnergyStored() : 0;
    }

    public int getAirStored() {
        return this.storedAir;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStorage.readFromNBT(nbt);
        this.storedAir = nbt.func_74762_e("StoredAir");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74768_a("StoredAir", this.storedAir);
    }

    public boolean onTick(int i) {
        return this.machineTick % i == 0;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateMaster() {
        ++this.machineTick;
        if (this.onTick(20) && this.energyStorage.extractEnergy(1000, true) >= 1000) {
            this.energyStorage.extractEnergy(1000, false);
            if (this.storedAir < 480) {
                ++this.storedAir;
                PacketHandler.sendAround(new PacketCompressor(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.storedAir, this.getEnergyStored(ForgeDirection.UP)), this);
            }
        }
    }

    public float getWheelAngle() {
        return 0.0f;
    }

    @Override
    public Class getTEClass() {
        return this.getClass();
    }

    @Override
    public boolean isPartnered(int x, int y, int z) {
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        return tile instanceof TileAirCompressor ? ((TileAirCompressor)tile).master != null : false;
    }

    public boolean isBaseBlock(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == this.func_145838_q() && this.field_145850_b.func_72805_g(x, y, z) == 0;
    }

    public boolean isTopBlock(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == this.func_145838_q() && this.field_145850_b.func_72805_g(x, y, z) == 1;
    }

    public boolean isBase(int x, int y, int z) {
        return this.isBaseBlock(x, y, z) && !this.isPartnered(x, y, z);
    }

    public boolean isTop(int x, int y, int z) {
        return this.isTopBlock(x, y, z) && !this.isPartnered(x, y, z);
    }

    @Override
    public void onBlockPlaced() {
        if (this.func_145832_p() == 0) {
            this.onBlockPlacedBase(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (this.func_145832_p() == 1) {
            this.onBlockPlacedTop(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void onBlockPlacedBase(int x, int y, int z) {
        ArrayList<TileMultiBlock.MultiPart> parts;
        TileMultiBlock.MultiPart mstr;
        if (this.isBase(x, y, z) && this.isBase(x + 1, y, z) && this.isTop(x, y + 1, z) && this.isTop(x + 1, y + 1, z)) {
            mstr = new TileMultiBlock.MultiPart(x, y, z);
            parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, x + 1, y, z, ForgeDirection.WEST));
            parts.add(this.setAsSlave(mstr, x + 1, y + 1, z, ForgeDirection.WEST));
            parts.add(this.setAsSlave(mstr, x, y + 1, z, ForgeDirection.EAST));
            this.setAsMaster(mstr, parts, ForgeDirection.EAST);
        }
        if (this.isBase(x, y, z) && this.isBase(x - 1, y, z) && this.isTop(x, y + 1, z) && this.isTop(x - 1, y + 1, z)) {
            mstr = new TileMultiBlock.MultiPart(x - 1, y, z);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.WEST));
            parts.add(this.setAsSlave(mstr, x - 1, y + 1, z, ForgeDirection.EAST));
            parts.add(this.setAsSlave(mstr, x, y + 1, z, ForgeDirection.WEST));
            this.setAsMaster(mstr, parts, ForgeDirection.EAST);
        }
        if (this.isBase(x, y, z) && this.isBase(x, y, z + 1) && this.isTop(x, y + 1, z) && this.isTop(x, y + 1, z + 1)) {
            mstr = new TileMultiBlock.MultiPart(x, y, z);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z + 1, ForgeDirection.SOUTH));
            parts.add(this.setAsSlave(mstr, x, y + 1, z + 1, ForgeDirection.SOUTH));
            parts.add(this.setAsSlave(mstr, x, y + 1, z, ForgeDirection.NORTH));
            this.setAsMaster(mstr, parts, ForgeDirection.NORTH);
        }
        if (this.isBase(x, y, z) && this.isBase(x, y, z - 1) && this.isTop(x, y + 1, z) && this.isTop(x, y + 1, z - 1)) {
            mstr = new TileMultiBlock.MultiPart(x, y, z - 1);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.SOUTH));
            parts.add(this.setAsSlave(mstr, x, y + 1, z - 1, ForgeDirection.NORTH));
            parts.add(this.setAsSlave(mstr, x, y + 1, z, ForgeDirection.SOUTH));
            this.setAsMaster(mstr, parts, ForgeDirection.NORTH);
        }
    }

    public void onBlockPlacedTop(int x, int y, int z) {
        ArrayList<TileMultiBlock.MultiPart> parts;
        TileMultiBlock.MultiPart mstr;
        if (this.isBase(x, y - 1, z) && this.isBase(x + 1, y - 1, z) && this.isTop(x, y, z) && this.isTop(x + 1, y, z)) {
            mstr = new TileMultiBlock.MultiPart(x, y - 1, z);
            parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.EAST));
            parts.add(this.setAsSlave(mstr, x + 1, y, z, ForgeDirection.WEST));
            parts.add(this.setAsSlave(mstr, x + 1, y - 1, z, ForgeDirection.WEST));
            this.setAsMaster(mstr, parts, ForgeDirection.EAST);
        }
        if (this.isBase(x, y - 1, z) && this.isBase(x - 1, y - 1, z) && this.isTop(x, y, z) && this.isTop(x - 1, y, z)) {
            mstr = new TileMultiBlock.MultiPart(x - 1, y - 1, z);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.WEST));
            parts.add(this.setAsSlave(mstr, x - 1, y, z, ForgeDirection.EAST));
            parts.add(this.setAsSlave(mstr, x, y - 1, z, ForgeDirection.WEST));
            this.setAsMaster(mstr, parts, ForgeDirection.EAST);
        }
        if (this.isBase(x, y - 1, z) && this.isBase(x, y - 1, z + 1) && this.isTop(x, y, z) && this.isTop(x, y, z + 1)) {
            mstr = new TileMultiBlock.MultiPart(x, y - 1, z);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z + 1, ForgeDirection.SOUTH));
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.NORTH));
            parts.add(this.setAsSlave(mstr, x, y - 1, z + 1, ForgeDirection.SOUTH));
            this.setAsMaster(mstr, parts, ForgeDirection.NORTH);
        }
        if (this.isBase(x, y - 1, z) && this.isBase(x, y - 1, z - 1) && this.isTop(x, y, z) && this.isTop(x, y, z - 1)) {
            mstr = new TileMultiBlock.MultiPart(x, y - 1, z - 1);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, x, y, z, ForgeDirection.SOUTH));
            parts.add(this.setAsSlave(mstr, x, y, z - 1, ForgeDirection.NORTH));
            parts.add(this.setAsSlave(mstr, x, y - 1, z, ForgeDirection.SOUTH));
            this.setAsMaster(mstr, parts, ForgeDirection.NORTH);
        }
    }
}

