/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.tile;

import java.util.ArrayList;
import java.util.Arrays;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.handlers.OreDicHandler;
import mariculture.core.helpers.BlockTransferHelper;
import mariculture.core.helpers.cofh.InventoryHelper;
import mariculture.core.tile.base.TileStorage;
import mariculture.core.util.IEjectable;
import mariculture.core.util.IItemDropBlacklist;
import mariculture.core.util.IMachine;
import mariculture.factory.items.ItemFilter;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileDictionaryItem
extends TileStorage
implements IItemDropBlacklist,
IMachine,
ISidedInventory,
IEjectable {
    private BlockTransferHelper helper;
    private FeatureEject.EjectSetting setting;
    private static final int[] filter = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] in = new int[]{24};
    private static final int[] out = new int[]{25, 26, 27, 28};

    public TileDictionaryItem() {
        this.inventory = new ItemStack[29];
        this.setting = FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return i >= 9;
    }

    public int[] func_94128_d(int side) {
        return new int[]{24, 25, 26, 27, 28};
    }

    public boolean func_102007_a(int i, ItemStack stack, int j) {
        return i == 24;
    }

    public boolean func_102008_b(int i, ItemStack stack, int j) {
        return i > 24;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (this.helper == null) {
            this.helper = new BlockTransferHelper(this);
        }
        if (this.func_102007_a(slot, stack, 0) && this.hasRoom() && stack != null) {
            int size = stack.field_77994_a;
            for (int i = 0; i < size; ++i) {
                if (stack == null) continue;
                this.swap();
            }
        }
        this.func_70296_d();
    }

    private boolean hasRoom() {
        if (this.setting.canEject(FeatureEject.EjectSetting.ITEM)) {
            return true;
        }
        for (int i : in) {
            if (this.func_70301_a(i) == null) continue;
            ItemStack orig = this.func_70301_a(i).func_77946_l();
            orig.field_77994_a = 1;
            ItemStack stack = this.convert(orig).func_77946_l();
            stack.field_77994_a = 1;
            if (!InventoryHelper.canAddItemStackToInventory(this.inventory, stack, out)) continue;
            return true;
        }
        return false;
    }

    private boolean hasItem() {
        for (int i : in) {
            if (this.func_70301_a(i) == null) continue;
            return true;
        }
        return false;
    }

    private void swap() {
        for (int i : in) {
            if (this.func_70301_a(i) == null) continue;
            ItemStack orig = this.func_70301_a(i).func_77946_l();
            orig.field_77994_a = 1;
            ItemStack stack = this.convert(orig).func_77946_l();
            stack.field_77994_a = 1;
            this.helper.insertStack(stack, out);
            this.func_70298_a(i, 1);
        }
    }

    private ItemStack convert(ItemStack stack) {
        for (int i : filter) {
            if (this.func_70301_a(i) == null) continue;
            ItemStack filtered = this.func_70301_a(i);
            if (filtered.func_77973_b() instanceof ItemFilter && filtered.func_77942_o()) {
                NBTTagList tagList = filtered.field_77990_d.func_150295_c("Inventory", 10);
                if (tagList == null) continue;
                for (int j = 0; j < tagList.func_74745_c(); ++j) {
                    ItemStack aStack;
                    NBTTagCompound nbt = tagList.func_150305_b(j);
                    byte byte0 = nbt.func_74771_c("Slot");
                    if (byte0 < 0 || byte0 >= 9 || !OreDicHandler.areEqual(aStack = ItemStack.func_77949_a((NBTTagCompound)nbt), stack)) continue;
                    ItemStack stack2 = aStack.func_77946_l();
                    if (stack2.func_77942_o() && stack2.field_77990_d.func_74764_b("OreDictionaryDisplay")) {
                        stack2.field_77990_d.func_82580_o("OreDictionaryDisplay");
                        if (stack2.field_77990_d.func_82582_d()) {
                            stack2.func_77982_d(null);
                        }
                    }
                    return stack2;
                }
                continue;
            }
            if (!OreDicHandler.areEqual(filtered, stack)) continue;
            ItemStack stack2 = filtered.func_77946_l();
            if (stack2.func_77942_o() && stack2.field_77990_d.func_74764_b("OreDictionaryDisplay")) {
                stack2.field_77990_d.func_82580_o("OreDictionaryDisplay");
                if (stack2.field_77990_d.func_82582_d()) {
                    stack2.func_77982_d(null);
                }
            }
            return stack2;
        }
        return stack;
    }

    @Override
    public void setGUIData(int id, int value) {
        if (id == 0) {
            this.setting = FeatureEject.EjectSetting.values()[value];
        }
    }

    @Override
    public ArrayList<Integer> getGUIData() {
        return new ArrayList<Integer>(Arrays.asList(this.setting.ordinal()));
    }

    @Override
    public boolean doesDrop(int slot) {
        return slot > 23;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public void handleButtonClick(int id) {
        if (id == -888) {
            this.setEjectSetting(FeatureEject.EjectSetting.toggle(this.getEjectType(), this.getEjectSetting()));
        }
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public FeatureEject.EjectSetting getEjectSetting() {
        return this.setting != null ? this.setting : FeatureEject.EjectSetting.NONE;
    }

    @Override
    public void setEjectSetting(FeatureEject.EjectSetting setting) {
        this.setting = setting;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setting = FeatureEject.EjectSetting.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        FeatureEject.EjectSetting.writeToNBT(nbt, this.setting);
    }
}

